% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_ncep.R
\name{download_ncep}
\alias{download_ncep}
\title{Download NCEP/NCAR data}
\usage{
download_ncep(var = "slp", level = "surface", month_range = c(1, 12),
  year_range = c(2010, 2017), lat_range = c(30, 60),
  lon_range = c(-30, 10), dailymean = TRUE, hour = NULL,
  reanalysis2 = TRUE, save_download = TRUE, file_name = NULL)
}
\arguments{
\item{var}{slp 'sea level pressure' (default) for more variables see help of ?NCEP.gather}

\item{level}{surface (default)}

\item{month_range}{min,max month c(1,12) (default)}

\item{year_range}{min,max year c(2010,2017) (default)}

\item{lat_range}{min,max latitude c(30, 60) (default)}

\item{lon_range}{min,max longitud c(-30, 10) (default)}

\item{dailymean}{daily avarage of the variable retrived. Default TRUE.}

\item{hour}{One hour of the following: 0,6,12 or 18.}

\item{reanalysis2}{Logical. Default TRUE. variables are downloaded from the NCEP-DOE Reanalysis 2. If FALSE, data downloaded from NCEP/NCAR Reanalysis 1}

\item{save_download}{Logical. Default TRUE. Do yoy want to save the downloaded data into an RDS file?}

\item{file_name}{character. Provide a name for the file downloaded.}
}
\value{
a data.frame with the following variables: \code{lon, lat, time, value}
}
\description{
Weather Data from NCEP/NCAR Reanalysis via RNCEP package
}
\examples{
\dontrun{
#Daily mean air temperature 2m for 2017
#ta_data <- download_ncep(year_range=2017)

#Air temperature 2m at 06:00 for 2017
#ta_data_h6 <- download_ncep(year_range=2017,dailymean = FALSE,hour=6)
}

}
