% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similar_votes.R
\name{similar_votes}
\alias{similar_votes}
\title{Obtain similarities a vote result shares with other votes}
\usage{
similar_votes(
  federalvotes = NULL,
  id = NULL,
  corr = TRUE,
  from = NULL,
  to = NULL
)
}
\arguments{
\item{federalvotes}{tibble or data.frame that is returned by 'get_swissvotes'.}

\item{id}{identification number of the vote, needs four digits. Vote 626 (Zersiedelungsinitiative) needs 6260.}

\item{corr}{set to TRUE by default. If FALSE return the variance-covariance matrix.}

\item{from}{lower limit of correlations.}

\item{to}{upper limit of correlations.}
}
\value{
a tibble containing the results
}
\description{
\code{similar_votes} allows to obtain correlations of specified vote with other votes.
}
\examples{
 \donttest{
 
 fedvotes <- get_nationalvotes(geolevel = "canton",from_date = "2010-03-07",to_date="2019-02-10")
 
 #Find correlating votes for the 'Zersiedelungsinitiative', 2019-02-10
 results <- similar_votes(fedvotes, id=6260)
 

#Zersiedelungsinitiative, 2019-02-10, filter stronger correlations (>0.5)
 results <- similar_votes(fedvotes, id=6260, from = 0.5)

}

}
