% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survregVB.R
\name{survregVB}
\alias{survregVB}
\title{Variational Bayesian Analysis of Survival Data Using a Log-Logistic
Accelerated Failure Time Model}
\usage{
survregVB(
  formula,
  data,
  alpha_0,
  omega_0,
  mu_0,
  v_0,
  lambda_0,
  eta_0,
  na.action,
  cluster,
  max_iteration = 100,
  threshold = 1e-04
)
}
\arguments{
\item{formula}{A formula object, with the response on the left of a \code{~}
operator, and the covariates on the right. The response must be a survival
object of type \code{right}, as returned by the \code{Surv} function.}

\item{data}{A \code{data.frame} in which to interpret the variables named in
the \code{formula} and \code{cluster} arguments.}

\item{alpha_0}{The shape hyperparameter \eqn{\alpha_0} of the prior
distribution of the scale parameter, \emph{b}.}

\item{omega_0}{The shape hyperparameter \eqn{\omega_0} of the prior
distribution of the scale parameter, \emph{b}.}

\item{mu_0}{Hyperparameter \eqn{\mu_0}, a vector of means, of the prior
distribution of the vector of coefficients, \eqn{\beta}.}

\item{v_0}{The precision (inverse variance) hyperparameter \eqn{v_0},
of the prior distribution of the vector of coefficients, \eqn{\beta}.}

\item{lambda_0}{The shape hyperparameter \eqn{\lambda_0} of the prior
distribution of the frailty variance, \eqn{\sigma_\gamma^2}.}

\item{eta_0}{The scale hyperparameter \eqn{\eta_0} of the prior distribution
of the frailty variance, \eqn{\sigma_\gamma^2}.}

\item{na.action}{A missing-data filter function, applied to the
\code{model.frame}, after any subset argument has been used.
(Default:\code{options()$na.action}).}

\item{cluster}{An optional variable which clusters the observations to
introduce shared frailty for correlated survival data.}

\item{max_iteration}{The maximum number of iterations for the variational
inference optimization. If reached, iteration stops. (Default:100)}

\item{threshold}{The convergence threshold for the evidence based lower
bound (ELBO) optimization. If the difference between the current and
previous ELBO's is smaller than this threshold, iteration stops.
(Default:0.0001)}
}
\value{
An object of class \code{survregVB}.
}
\description{
Applies a mean-field Variational Bayes (VB) algorithm to infer the
parameters of an accelerated failure time (AFT) survival model with
right-censored survival times following a log-logistic distribution.
}
\details{
The goal of \code{survregVB} is to maximize the evidence lower bound
(ELBO) to approximate posterior distributions of the AFT model parameters
using the VB algorithms with and without shared frailty proposed in Xian
et al. (2024) \url{doi:10.1007/s11222-023-10365-6} and
\url{doi:10.48550/ARXIV.2408.00177} respectively.
}
\examples{
# Data frame containing survival data
fit <- survregVB(
  formula = survival::Surv(time, infect) ~ trt + fev,
  data = dnase,
  alpha_0 = 501,
  omega_0 = 500,
  mu_0 = c(4.4, 0.25, 0.04),
  v_0 = 1,
  max_iteration = 100,
  threshold = 0.0005
)
summary(fit)

# Call the survregVB function with shared frailty
fit2 <- survregVB(
  formula = survival::Surv(Time.15, delta.15) ~ x1 + x2,
  data = simulation_frailty,
  alpha_0 = 3,
  omega_0 = 2,
  mu_0 = c(0, 0, 0),
  v_0 = 0.1,
  lambda_0 = 3,
  eta_0 = 2,
  cluster = cluster,
  max_iteration = 100,
  threshold = 0.01
)
summary(fit2)
}
\references{
Xian, C., Souza, C. P. E. de, He, W., Rodrigues, F. F.,
& Tian, R. (2024). "Variational Bayesian analysis of survival data
using a log-logistic accelerated failure time model." Statistics and
Computing, 34(2). https://doi.org/10.1007/s11222-023-10365-6

Xian, C., Souza, C. P. E. de, He, W., Rodrigues, F. F.,
& Tian, R. (2024). "Fast variational bayesian inference for correlated
survival data: An application to invasive mechanical ventilation
duration analysis." https://doi.org/10.48550/ARXIV.2408.00177
}
\seealso{
\code{\link{survregVB.object}}
}
