% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styling.R
\name{add_group_colors}
\alias{add_group_colors}
\title{Add background colors to group headers with automatic gt conversion}
\usage{
add_group_colors(tbl, color = "#E8E8E8")
}
\arguments{
\item{tbl}{A gtsummary table object with variable group headers created by
\code{gtsummary::add_variable_group_header()}}

\item{color}{Background color for group headers. Default \code{"#E8E8E8"} (light gray).
Can be any valid CSS color (hex code, color name, rgb(), etc.).}
}
\value{
A gt table object with colored group headers.
\strong{Note:} This is a terminal operation that converts to gt. You cannot pipe
to additional gtsummary functions after calling this function.
}
\description{
Convenience function that adds background colors to variable group
headers and converts the table to gt. This is a terminal operation that combines
\code{get_group_rows()}, \code{gtsummary::as_gt()}, and \code{gt::tab_style()} into a single
pipeable function.

For text formatting (bold/italic), use \code{add_group_styling()} before calling this
function. This composable design keeps each function focused on doing one thing well.
}
\details{
This function:
\enumerate{
\item Identifies group header rows with \code{get_group_rows()}
\item Converts the table to gt with \code{gtsummary::as_gt()}
\item Applies background color using \code{gt::tab_style()}
}

Since this function converts to gt, it should be used as the final styling
step in your pipeline. Apply all gtsummary functions (like \code{modify_caption()},
\code{modify_footnote()}, etc.) and text formatting with \code{add_group_styling()}
before calling \code{add_group_colors()}.
}
\examples{
\donttest{
# Basic usage - text formatting then color
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras() |>
  gtsummary::add_variable_group_header(
    header = "Patient Characteristics",
    variables = age:stage
  ) |>
  add_group_styling() |>
  add_group_colors()

# Custom color - light blue
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras() |>
  gtsummary::add_variable_group_header(
    header = "Baseline Characteristics",
    variables = age:marker
  ) |>
  add_group_styling() |>
  add_group_colors(color = "#E3F2FD")

# Bold only formatting with custom color
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras() |>
  gtsummary::add_variable_group_header(
    header = "Clinical Measures",
    variables = marker:stage
  ) |>
  add_group_styling(format = "bold") |>
  add_group_colors(color = "#FFF9E6")

# Multiple group headers
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras() |>
  gtsummary::add_variable_group_header(
    header = "Demographics",
    variables = age
  ) |>
  gtsummary::add_variable_group_header(
    header = "Disease Measures",
    variables = marker:response
  ) |>
  add_group_styling() |>
  add_group_colors(color = "#E8E8E8")
}

}
\seealso{
\itemize{
\item \code{add_group_styling()} for text formatting only (stays gtsummary)
\item \code{get_group_rows()} for identifying group header rows
\item \code{gtsummary::add_variable_group_header()} for creating variable groups
\item \code{gt::tab_style()} for additional gt-specific styling
}
}
