/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math.linear.EigenDecomposition;
import org.apache.commons.math.linear.EigenDecompositionImpl;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SingularValueDecomposition;
import org.apache.commons.math.util.FastMath;

public class SingularValueDecompositionImpl
implements SingularValueDecomposition {
    private int m;
    private int n;
    private EigenDecomposition eigenDecomposition;
    private double[] singularValues;
    private RealMatrix cachedU;
    private RealMatrix cachedUt;
    private RealMatrix cachedS;
    private RealMatrix cachedV;
    private RealMatrix cachedVt;

    public SingularValueDecompositionImpl(RealMatrix matrix) throws InvalidMatrixException {
        int i;
        int p;
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.cachedU = null;
        this.cachedS = null;
        this.cachedV = null;
        this.cachedVt = null;
        double[][] localcopy = matrix.getData();
        double[][] matATA = new double[this.n][this.n];
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j = i2; j < this.n; ++j) {
                matATA[i2][j] = 0.0;
                for (int k = 0; k < this.m; ++k) {
                    double[] dArray = matATA[i2];
                    int n = j;
                    dArray[n] = dArray[n] + localcopy[k][i2] * localcopy[k][j];
                }
                matATA[j][i2] = matATA[i2][j];
            }
        }
        double[][] matAAT = new double[this.m][this.m];
        for (int i3 = 0; i3 < this.m; ++i3) {
            for (int j = i3; j < this.m; ++j) {
                matAAT[i3][j] = 0.0;
                for (int k = 0; k < this.n; ++k) {
                    double[] dArray = matAAT[i3];
                    int n = j;
                    dArray[n] = dArray[n] + localcopy[i3][k] * localcopy[j][k];
                }
                matAAT[j][i3] = matAAT[i3][j];
            }
        }
        if (this.m >= this.n) {
            p = this.n;
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matATA), 1.0);
            this.singularValues = this.eigenDecomposition.getRealEigenvalues();
            this.cachedV = this.eigenDecomposition.getV();
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matAAT), 1.0);
            this.cachedU = this.eigenDecomposition.getV().getSubMatrix(0, this.m - 1, 0, p - 1);
        } else {
            p = this.m;
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matAAT), 1.0);
            this.singularValues = this.eigenDecomposition.getRealEigenvalues();
            this.cachedU = this.eigenDecomposition.getV();
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matATA), 1.0);
            this.cachedV = this.eigenDecomposition.getV().getSubMatrix(0, this.n - 1, 0, p - 1);
        }
        for (i = 0; i < p; ++i) {
            this.singularValues[i] = FastMath.sqrt(FastMath.abs(this.singularValues[i]));
        }
        for (i = 0; i < p; ++i) {
            RealVector tmp = this.cachedU.getColumnVector(i);
            double product = matrix.operate(this.cachedV.getColumnVector(i)).dotProduct(tmp);
            if (!(product < 0.0)) continue;
            this.cachedU.setColumnVector(i, tmp.mapMultiply(-1.0));
        }
    }

    public RealMatrix getU() throws InvalidMatrixException {
        return this.cachedU;
    }

    public RealMatrix getUT() throws InvalidMatrixException {
        if (this.cachedUt == null) {
            this.cachedUt = this.getU().transpose();
        }
        return this.cachedUt;
    }

    public RealMatrix getS() throws InvalidMatrixException {
        if (this.cachedS == null) {
            this.cachedS = MatrixUtils.createRealDiagonalMatrix(this.singularValues);
        }
        return this.cachedS;
    }

    public double[] getSingularValues() throws InvalidMatrixException {
        return (double[])this.singularValues.clone();
    }

    public RealMatrix getV() throws InvalidMatrixException {
        return this.cachedV;
    }

    public RealMatrix getVT() throws InvalidMatrixException {
        if (this.cachedVt == null) {
            this.cachedVt = this.getV().transpose();
        }
        return this.cachedVt;
    }

    public RealMatrix getCovariance(double minSingularValue) {
        int dimension;
        int p = this.singularValues.length;
        for (dimension = 0; dimension < p && this.singularValues[dimension] >= minSingularValue; ++dimension) {
        }
        if (dimension == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.TOO_LARGE_CUTOFF_SINGULAR_VALUE, minSingularValue, this.singularValues[0]);
        }
        final double[][] data = new double[dimension][p];
        this.getVT().walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            public void visit(int row, int column, double value) {
                data[row][column] = value / SingularValueDecompositionImpl.this.singularValues[row];
            }
        }, 0, dimension - 1, 0, p - 1);
        Array2DRowRealMatrix jv = new Array2DRowRealMatrix(data, false);
        return jv.transpose().multiply(jv);
    }

    public double getNorm() throws InvalidMatrixException {
        return this.singularValues[0];
    }

    public double getConditionNumber() throws InvalidMatrixException {
        return this.singularValues[0] / this.singularValues[this.singularValues.length - 1];
    }

    public int getRank() throws IllegalStateException {
        double threshold = (double)FastMath.max(this.m, this.n) * FastMath.ulp(this.singularValues[0]);
        for (int i = this.singularValues.length - 1; i >= 0; --i) {
            if (!(this.singularValues[i] > threshold)) continue;
            return i + 1;
        }
        return 0;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.singularValues, this.getUT(), this.getV(), this.getRank() == Math.max(this.m, this.n));
    }

    private static class Solver
    implements DecompositionSolver {
        private final RealMatrix pseudoInverse;
        private boolean nonSingular;

        private Solver(double[] singularValues, RealMatrix uT, RealMatrix v, boolean nonSingular) {
            double[][] suT = uT.getData();
            for (int i = 0; i < singularValues.length; ++i) {
                double a = singularValues[i] > 0.0 ? 1.0 / singularValues[i] : 0.0;
                double[] suTi = suT[i];
                int j = 0;
                while (j < suTi.length) {
                    int n = j++;
                    suTi[n] = suTi[n] * a;
                }
            }
            this.pseudoInverse = v.multiply(new Array2DRowRealMatrix(suT, false));
            this.nonSingular = nonSingular;
        }

        public double[] solve(double[] b) throws IllegalArgumentException {
            return this.pseudoInverse.operate(b);
        }

        public RealVector solve(RealVector b) throws IllegalArgumentException {
            return this.pseudoInverse.operate(b);
        }

        public RealMatrix solve(RealMatrix b) throws IllegalArgumentException {
            return this.pseudoInverse.multiply(b);
        }

        public boolean isNonSingular() {
            return this.nonSingular;
        }

        public RealMatrix getInverse() {
            return this.pseudoInverse;
        }
    }
}

