% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{flow}
\alias{flow}
\title{Data frame of commuter flows}
\format{
A data frame with 49 rows and 15 columns
}
\description{
This dataset represents commuter flows (work travel) between origin
and destination zones.
The data is from the UK and is available as open data:
\url{https://wicid.ukdataservice.ac.uk/}.
}
\details{
The variables are as follows:

\itemize{
\item Area.of.residence. id of origin zone
\item Area.of.workplace id of destination zone
\item All. Travel to work flows by all modes
\item \verb{[,4:15]}. Flows for different modes
\item id. unique id of flow
}
Although these variable names are unique to UK data, the data
structure is generalisable and typical of flow data from any source.
The key variables are the origin and destination ids, which link to
the georeferenced spatial objects.
}
\seealso{
Other data: 
\code{\link{cents_sf}},
\code{\link{destinations_sf}},
\code{\link{flow_dests}},
\code{\link{flowlines_sf}},
\code{\link{od_data_lines}},
\code{\link{od_data_routes}},
\code{\link{od_data_sample}},
\code{\link{osm_net_example}},
\code{\link{read_table_builder}()},
\code{\link{route_network_sf}},
\code{\link{routes_fast_sf}},
\code{\link{routes_slow_sf}},
\code{\link{zones_sf}}

Other data: 
\code{\link{cents_sf}},
\code{\link{destinations_sf}},
\code{\link{flow_dests}},
\code{\link{flowlines_sf}},
\code{\link{od_data_lines}},
\code{\link{od_data_routes}},
\code{\link{od_data_sample}},
\code{\link{osm_net_example}},
\code{\link{read_table_builder}()},
\code{\link{route_network_sf}},
\code{\link{routes_fast_sf}},
\code{\link{routes_slow_sf}},
\code{\link{zones_sf}}
}
\concept{data}
\keyword{datasets}
