% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overline.R
\name{overline_spatial}
\alias{overline_spatial}
\title{Spatial aggregation of routes represented with sp classes}
\usage{
overline_spatial(sl, attrib, fun = sum, na.zero = FALSE, buff_dist = 0)
}
\arguments{
\item{sl}{SpatialLinesDataFrame with overlapping Lines to split by
number of overlapping features.}

\item{attrib}{character, column names in sl to be aggregated}

\item{fun}{Named list of functions to summaries the attributes by? \code{sum} is the default.
\code{list(sum = sum, average = mean)} will summarise all \code{attrib}utes by sum and mean.}

\item{na.zero}{Sets whether aggregated values with a value of zero are
removed.}

\item{buff_dist}{A number specifying the distance in meters of the buffer to be used to crop lines before running the operation.
If the distance is zero (the default) touching but non-overlapping lines may be aggregated.}
}
\description{
This function, largely superseded by sf implementations, still works
but is not particularly fast.
}
\seealso{
Other rnet: 
\code{\link{SpatialLinesNetwork}},
\code{\link{calc_catchment_sum}()},
\code{\link{calc_catchment}()},
\code{\link{calc_moving_catchment}()},
\code{\link{calc_network_catchment}()},
\code{\link{find_network_nodes}()},
\code{\link{gsection}()},
\code{\link{islines}()},
\code{\link{lineLabels}()},
\code{\link{overline}()},
\code{\link{plot,SpatialLinesNetwork,ANY-method}},
\code{\link{plot,sfNetwork,ANY-method}},
\code{\link{rnet_breakup_vertices}()},
\code{\link{rnet_group}()},
\code{\link{sln2points}()},
\code{\link{sum_network_links}()},
\code{\link{sum_network_routes}()}
}
\concept{rnet}
