% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toptail.R
\name{buff_geo}
\alias{buff_geo}
\title{Create a buffer of n metres for non-projected 'geographical' spatial data}
\usage{
buff_geo(shp, width, ...)
}
\arguments{
\item{shp}{A spatial object with a geographic CRS (e.g. WGS84)
around which a buffer should be drawn}

\item{width}{The distance (in metres) of the buffer (when buffering sp objects)}

\item{...}{Arguments passed to the buffer (see \code{?rgeos::gBuffer} or \code{?sf::st_buffer} for details)}
}
\description{
Solves the problem that buffers will not be circular when used on
non-projected data.
}
\details{
Returns a
}
\examples{
buff <- buff_geo(routes_fast, width = 100)
plot(buff)
plot(routes_fast, add = TRUE)
# Test it works the same on projected data
shp <- spTransform(routes_fast, CRS("+init=epsg:27700"))
buff2 = buff_geo(shp, 50) # test if it works the same on projected data
plot(buff2)
plot(routes_fast, add = TRUE) # note they do not show
buff3 = spTransform(buff2, CRS("+init=epsg:4326"))
plot(buff)
plot(buff3, add = TRUE, col = "black")
}
