% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geo-functions.R
\name{gclip}
\alias{gclip}
\title{Crops spatial object x to the bounding box of spatial object (or matrix) b}
\usage{
gclip(shp, bb)
}
\arguments{
\item{shp}{The spatial object a to be cropped}

\item{bb}{the bounding box or spatial object that will be used to crop \code{shp}}
}
\description{
This function is a cross between the spatial subsetting funtions such as
sp::over(), rgeos::gIntersects() etc, and the cropping functions of
raster::crop() and rgeos::gIntersection(). The output is the subset of
spatial object a with an outline described by a square bounding box.
The utility of such a function is illustrated in the following question:
\url{http://gis.stackexchange.com/questions/46954/clip-spatial-object-to-bounding-box-in-r/}.
}
\examples{
library(sp)
data(cents)
bb <- bbox(cents)
cb <- rgeos::gBuffer(cents[8, ], width = 0.012, byid = TRUE)
plot(cents)
plot(cb, add = TRUE)
clipped <- gclip(cents, cb)
row.names(clipped)
clipped$avslope # gclip also returns the data attribute
points(clipped)
points(cents[cb,], col = "red") # note difference
}

