% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{statprograms}
\alias{statprograms}
\title{Graduate Statistics Program Data}
\format{A \code{data.frame} with 490 observations and 16 columns. The columns are defined as follows:
\describe{
 \item{\code{school}}{The college}
 \item{\code{program}}{The program type as advertised by the department}
 \item{\code{program_category}}{The program type categorized as either "Statistics" or "Biostatistics"}
 \item{\code{degree}}{The degree given by the department}
 \item{\code{degree_category}}{The degree categorized as either "Master" or "Doctorate"}
 \item{\code{state}}{The state}
 \item{\code{city}}{The city}
 \item{\code{square_miles}}{The square miles of the city (or region) from \url{https://www.wikipedia.org/}}
 \item{\code{population}}{The population of the city (or region) from \url{https://www.wikipedia.org/} or \url{https://www.census.gov/programs-surveys/popest/data/data-sets.html}. Most are estimates from 2010 to 2014.}
 \item{\code{density}}{The population density}
 \item{\code{average_winter}}{The average winter temperature from \url{http://weatherdb.com}}
 \item{\code{average_summer}}{The average summer temperature from \url{http://weatherdb.com}}
 \item{\code{latitude}}{The latitude of the department's building (or as close as possible) from \url{http://www.gps-coordinates.net}}
 \item{\code{longitude}}{The longitude of the department's building (or as close as possible) from \url{http://www.gps-coordinates.net}}
 \item{\code{link}}{The URL of the department's website}
 \item{\code{date_collected}}{The date the information was recorded}
}}
\usage{
statprograms
}
\description{
This dataset contains various information from the majority of graduate statistics programs in the United States.
}
\examples{
\dontrun{
data(statprograms)
summary(statprograms)

#----------------------------------------------------------------------------
# Plot locations on a map
#----------------------------------------------------------------------------
library(maps)
library(ggplot2)
library(mapproj)

us_states <- map_data("state")

ggplot(
  data = statprograms[statprograms$state != "Alaska", ],
  mapping = aes(x = longitude, y = latitude)
) +
  geom_polygon(
    data = us_states,
    aes(x = long, y = lat, group = group),
    fill = "white",
    color = "gray50",
    size = 0.5
  ) +
  geom_point() +
  guides(fill = FALSE) +
  coord_map(
    projection = "albers",
    lat0 = 39,
    lat1 = 45
  ) +
  theme_bw()
}
}
\author{
Brett Klamer
}
\keyword{datasets}
