% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskFactor.R
\name{currency}
\alias{currency}
\title{Constructing a Currency (FX Exchange Rate Risk Factor)}
\usage{
currency(name, from, to)
}
\arguments{
\item{name}{a character value of length one. This corresponds to the name in the covariance matrix of the \code{marketRisk}
to which the currency risk factor is mapped. This means that the risk factor change \eqn{\Delta RF_{t,FX_{j}}}
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"} will be assumed
to be modeled by the underlying normal random variable corresponding to \code{name} in the covariance matrix.}

\item{from}{a character value of length one. The starting currency corresponding to the FX index \code{j}
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{to}{a character value of length one. The arrival currency to which the exchange rate \eqn{FX_{j}} is mapped.}
}
\value{
An S3 object, instance of the class currency.
}
\description{
Constructor for the
  S3 class currency. It allows to define a currency (fx rate) risk factor. This risk factor refers
  to the \emph{"Fremdwährungsrisikofaktors"} change \eqn{\Delta RF_{t,FX_{j}}} for a certain index \code{j} in the
  all valuation functions at presented
  in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
}
\note{
Please consider that we do not allow for scaled currency risk factors.
}
\examples{
# constructing a currency risk factor
# (assuming "EURCHF" exists in marketRisk).
cur <- currency(name = "EURCHF",
                from = "EUR",
                to   = "CHF")

}
