% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskFactor.R
\name{pcRate}
\alias{pcRate}
\title{Constructing a Principal Component Rate (Risk Factor)}
\usage{
pcRate(name, currency, scale = NULL)
}
\arguments{
\item{name}{a character value of length one. This corresponds to the name in the covariance
matrix of the \code{marketRisk} to which the principal component rate risk factor is mapped.
This means that the principal component change will be assumed to be modeled by the underlying
normal random variable corresponding to \code{name} in the covariance matrix
(potentially scaled by \code{scale} if not \code{NULL}).}

\item{currency}{a character value of length one. The currency in which the underlying
rate is modelling. This refers to the currency corresponding to the index \code{j}
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{scale}{a numeric value of length one. If not set \code{NULL},
this defines a scaled risk factor equal to \code{scale} times
the risk factor defined by \code{name} in the covariance matrix contained in \code{marketRisk}.
By default its value is \code{scale = NULL}.}
}
\value{
An S3 object, instance of the class pcRate.
}
\description{
Constructor for the
  S3 class pcRate. It allows to define a principal component of rate curves risk factor. This risk factor refers
  to a principal component in the decomposition of the \emph{"stetigen Zins"} change \eqn{\Delta R_{j}(t, i_{\tau})}
  for a certain \code{horizon} index \eqn{i_{\tau}} and a certain \code{currency} j in the
  valuation function for \emph{"Fixed-Income-Assets und Versicherungsverpflichtungen"} presented
  in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
}
\examples{
# constructing a principal component rate risk factor
# (assuming "2Y_CHF" exists in marketRisk).
p <- pcRate(name = "pcRate_EUR_1", currency = "EUR")

}
