% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull.R
\name{weibull}
\alias{weibull}
\alias{dweibull}
\alias{pweibull}
\alias{qweibull}
\alias{rweibull}
\title{Weibull Distribution}
\usage{
dweibull(x, shape = 1, scale = 1, log = FALSE)

pweibull(q, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

qweibull(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

rweibull(n, shape = 1, scale = 1)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{scale}{scale parameter.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Density, distribution function, quantile function and random generation for
the weibull distribution with parameters shape and scale.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dweibull(x), type = "l")
}
\seealso{
\code{\link[stats:Weibull]{stats::dweibull()}}
}
