% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windowfunctions.R
\name{Windowfunctions}
\alias{Windowfunctions}
\title{Windowfunctions}
\value{
All window functions return a wighting vector with the same length
as the provided data vector.
}
\description{
Some typical windowfunctions are defined below:
}
\details{
\describe{
   \item{\code{win.cos()}}{cosine window}
   \item{\code{win.tukey()}}{the tukey window}
}

A window function weights a given dataset in a way, that the new data set is
coerced to be periodic. This method reduces the leakage effects of the Fourier
transform.
}
\examples{
y <- 1:100
y_cos <- y * win.cos(y)
y_tuk <- y * win.tukey(y)

# Plot the original data
plot(y,main="Effect of window functions")
legend("topleft",c("original","cos","tukey"),pch=c(16,17))
points(y_cos,pch=16)
points(y_tuk,pch=17)


}

