% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.spdur.R
\name{accessors}
\alias{accessors}
\alias{logLik.spdur}
\alias{nobs.spdur}
\alias{coef.spdur}
\alias{vcov.spdur}
\alias{model.matrix.spdur}
\alias{terms.spdur}
\title{Accessor methods for spdur Objects}
\usage{
\method{logLik}{spdur}(object, ...)

\method{nobs}{spdur}(object, ...)

\method{coef}{spdur}(object, model = c("full", "duration", "risk", "distr"), ...)

\method{vcov}{spdur}(object, model = c("full", "duration", "risk", "distr"), ...)

\method{model.matrix}{spdur}(object, model = c("duration", "risk"), ...)

\method{terms}{spdur}(x, model = c("duration", "risk"), ...)
}
\arguments{
\item{object}{an object inheriting from class \code{spdur}.}

\item{\dots}{not used}

\item{model}{return full model, or only duration or risk equations, or 
distribution parameters.}

\item{x}{\code{spdur} class object for terms}
}
\description{
Several standard accessor methods for a \code{spdur} class object.
}
\examples{
data(model.coups)

logLik(model.coups)

nobs(model.coups)

coef(model.coups)

vcov(model.coups)

head(model.matrix(model.coups))

terms(model.coups)

}
\seealso{
\code{\link{AIC.spdur}}, \code{\link{BIC.spdur}}
}
