% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spa_align.R
\name{spa_align}
\alias{spa_align}
\title{Stratigraphic Plug Alignment (SPA)}
\usage{
spa_align(ref, ..., depth_col = "Depth_m", rule = 1, add_suffix = TRUE)
}
\arguments{
\item{ref}{A data.frame containing the reference depth grid and (optionally)
high-resolution variables (e.g., XRF). Must contain the depth column
specified in \code{depth_col}.}

\item{...}{One or more named data.frames containing plug-based measurements
to be interpolated (e.g., \code{xrd = xrd_df}, \code{plugs = plug_df}).}

\item{depth_col}{A character string giving the name of the depth column
shared by all input datasets. Defaults to \code{"Depth_m"}.
The depth column may use any unit (e.g., meters, feet, centimeters);
\code{"Depth_m"} is only a column label and does not require depths to be
in meters. However, all input datasets must use the same depth unit for
interpolation to be meaningful.}

\item{rule}{Integer passed to \code{approx()} (default \code{1}).
\code{rule = 1} prevents extrapolation outside the observed depth range.}

\item{add_suffix}{Logical; if \code{TRUE}, variable names are suffixed with
the dataset name (e.g., \code{TOC_plugs}, \code{Quartz_xrd}).}
}
\value{
A data.frame containing the reference depth grid and interpolated
variables aligned to the same resolution.
}
\description{
Linearly interpolates plug-based measurements (e.g., TOC, porosity, XRD)
onto a high-resolution reference depth grid (e.g., XRF).
The procedure uses base R's \code{approx()} with \code{rule = 1} to prevent
extrapolation beyond the observed depth range, ensuring stratigraphically
consistent alignment of all datasets.
}
\details{
SPA is intended for vertically ordered core or log data, where measurements
are indexed by depth along a stratigraphic profile.
}
\examples{
# Synthetic example (for illustration)
ref <- data.frame(Depth_m = 0:10, Ca = runif(11, 100, 200))
xrd <- data.frame(Depth_m = c(2, 5, 7), Quartz = c(54, 60, 58))
plugs <- data.frame(Depth_m = c(3, 7, 9), TOC = c(3.0, 3.3, 3.5))

aligned <- spa_align(ref, xrd = xrd, plugs = plugs)
head(aligned)

}
