% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourcoise.R
\name{sourcoise}
\alias{sourcoise}
\title{sources R script and caches results on disk}
\usage{
sourcoise(
  path,
  args = list(),
  track = list(),
  lapse = getOption("sourcoise.lapse"),
  force_exec = getOption("sourcoise.force_exec"),
  prevent_exec = getOption("sourcoise.prevent_exec"),
  metadata = getOption("sourcoise.metadata"),
  wd = getOption("sourcoise.wd"),
  src_in = getOption("sourcoise.src_in"),
  exec_wd = NULL,
  root = NULL,
  quiet = TRUE,
  nocache = FALSE,
  inform = FALSE,
  log = getOption("sourcoise.log"),
  grow_cache = getOption("sourcoise.grow_cache"),
  limit_mb = getOption("sourcoise.limit_mb")
)
}
\arguments{
\item{path}{(character) path of the script to execute (see details).}

\item{args}{(list) list of args that can be used in the script (in the form \code{args$xxx}).}

\item{track}{(list) list of files which modification triggers cache invalidation and script execution .}

\item{lapse}{(character) duration over which cache is invalidated. Could be \code{never} (default) \verb{x hours}, \verb{x days}, \verb{x week}, \verb{x months}, \verb{x quarters}, \verb{x years}.}

\item{force_exec}{(boolean) execute code, disregarding cache valid or invalid.}

\item{prevent_exec}{(boolean) prevent execution, cache valid or not, returned previous cached data, possibly invalid.}

\item{metadata}{(boolean) if TRUE \code{sourcoise()} returns a list with data is the \verb{$data}  and various meta data (see details).}

\item{wd}{(character) if \code{project} working directory for the execution of script will be the root of the project. If \code{file} then it will be the dir of the script (défaut) If \code{qmd}, then working dir will be the dir in which the calling \code{qmd} is. Current directory is restored after execution (successful or failed).}

\item{src_in}{(character) if \code{project} searches for source starting at the root of the project, if "file" searches in qmd dir. If "wd", then in working directory. Cache folder (\code{.sourcoise}) is stored there.}

\item{exec_wd}{(character) force exec dir (expert use).}

\item{root}{(character) force root (expert use).}

\item{quiet}{(boolean) mute messages and warnings from script execution.}

\item{nocache}{(boolean) no caching.}

\item{inform}{(boolean) Display logs on console, even if logging is disabled with threshold level "INFO".}

\item{log}{("OFF" par défaut) log threshold (see \code{logger::log_treshold()}).}

\item{grow_cache}{(5 par défaut) cache limit in number of data file kept.}

\item{limit_mb}{(50 par défaut) individual cache data files size on disk limit. If above \strong{no caching}.}
}
\value{
data (list ou ce que le code retourne)
}
\description{
\code{sourcoise()} is used as a drop in replacement for \code{base::source()} but caches results on disk. Cache is persistant over sessions.
}
\details{
\code{sourcoise()} looks like \code{base::source()}. However, there are some minor differences.

First, the script called in \code{sourcoise()} must end by a \code{return()} or by an object returned. Assignment made in the script won't be kept as \code{sourcoise()} is executed locally. Only explicitly reruned object will be returned. So \code{soucoise()} is used by assigning its result to something (\verb{aa <- sourcoise("mon_script.r)} or \verb{sourcoise() |> ggplot() ...}). Unless specified otherwise with \code{wd} parameter, the working directory for the script execution is (temporarly) set to the dir in which is the script. That allows for simple access to companion files and permit to move the script and companion files to another dir or project.

Second, an heuristic is applied to find the script, in the event the path given is incomplete. Whereas it is not advised and comes with a performance cost, this can be useful when there is a change in the structure of the project. The heuristic is simple, the script is searched inside the porject dir and among all hits the closest to the caller is returned.

Third, if an error is triggered by the script, \code{sourcoise()} does not fail and return the error and a NULL return. However, if there is a (invalid or valid) cache, the cached data is returned allowing for the script to continue. In that case the error is logged.

Cache is invalidated when :
1 -   a cache is not found
2 -   the script has been modified
3 -   tracked files have been modified
4 -   last execution occurred a certain time ago and is considered as expired
5 -   execution is forced

If \code{src_in="file"}, then script \code{path} is searched from the \code{.qmd} dir. If no \code{.qmd} esxits (or is not the caller) the the current work dir is used (which is the usual way \code{base::source} works).
If \code{src_in="project"}, then script \code{path} is searched from the root dir of the project, being a Rproject or a quarto project, using the package \code{{rprojroot}}. This guarantees to find the script without using current working directory and is a more robust way to proceed.

Usually the fisrt call return and cache the results. Results can be aby R object and are serialized and saved using \code{qs2}. Subsequent calls, supposing none of cache invalidation are true, are then very quick. No logging is used, data is fecteched from the cache and that's it. For standard size data, used in a table or a graph (< 1Mb roughly), return timing is under 5ms.

\code{lapse} parameter is used for invalidation trigger 4. \code{lapse = "1 day"} ou \code{lapse="day"} for instance will trigger once a day the execution. \code{lapse = "3 days"} will do it every 72h. \code{hours}, \code{weeks}, \code{months}, \code{quarters} or \code{years} are understood time units. MOre complex calendar instructions could be added, but \code{sourcoise_refesh()} provides a solution more general and easy to adapt to any use case, as to my knowledge, there is no general mechanism to be warned of data updates.

\code{track} is the trigger #3. It is simply a list of files (following path convention defined by \code{scr_in}, so either script dir of project dir as reference). If the files in the list are changed then the execution is triggered. It is done with a hash and it is difficult to have a croo plateform hash for excel files. Nevertheless, hash is done on text files with same results of different platforms.

If \code{metadata=TRUE}, a list is returned, with some metadatas. Main ones are \verb{$data}, the data returned, \verb{$date}, execution date, \verb{$timing} execution timing, \verb{$size} of the R object in memory, \verb{$data_file} and \verb{"data_date} documenting data file path and last modification date (see below), parameters of the call (\verb{$track}, \verb{$wd}, \verb{$src_in}, \verb{$args} and so on).

\code{force_exec} and \code{prevent_exec} are parameters that force the script execution (trigger #5) of prevent it (so cache is returned or NULL if no cache). Those 2 parameters can be set for one specific execution, but they are intendend to a global setting through the option \code{sourcoise.force_exec} or \code{sourcoise.prevent_exec}.

If returned data after execution is not different than previously cached data, then no caching occurs in order to limit the disk use and to avoid keeping an histoiry of the same data files. This implies the possibility of a difference between last execution date and last data modification date.

Working with github : \code{sourcoise()} is designed to function with \emph{github}. Cache information is specific to each user (avoiding conflicts) and cached data is named with the hash. Conflicts could occur in the rare case the same script is executed on different machines and that this script return each time a different result (such as a random generator).
}
\examples{
\dontshow{if (rlang::is_installed("insee")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dir <- tempdir()
fs::file_copy(
   fs::path_package("sourcoise", "ipch", "prix_insee.R"),
  dir,
  overwrite = TRUE)
# Force execution (root is set explicitly here, it is normally deduced from project)
data <- sourcoise("prix_insee.R", root = dir, force_exec = TRUE)
# The second time cache is used
data <- sourcoise("prix_insee.R", root = dir)
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed(c("insee", "bench"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Performance and mem test
dir <- tempdir()
fs::file_copy(
   fs::path_package("sourcoise", "ipch", "prix_insee.R"),
   dir,
   overwrite = TRUE)
bench::mark(
 forced = data <- sourcoise("prix_insee.r", root = dir, force_exec = TRUE),
 cached = data <- sourcoise("prix_insee.r", root = dir),
 max_iterations = 5)
\dontshow{\}) # examplesIf}
}
\seealso{
Other sourcoise: 
\code{\link{sourcoise_clear}()},
\code{\link{sourcoise_refresh}()},
\code{\link{sourcoise_reset}()},
\code{\link{sourcoise_status}()}
}
\concept{sourcoise}
