% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftPitch.R
\name{dPhase}
\alias{dPhase}
\title{Phase derivatives}
\usage{
dPhase(
  phase,
  magn,
  step_s,
  freqs,
  alpha,
  propagation = c("time", "adaptive")[1],
  tol = 10^(-6),
  nr = nrow(phase),
  nc = ncol(phase)
)
}
\arguments{
\item{phase, magn}{phase and magnitude of a spectrogram}

\item{step_s}{step in s}

\item{freqs}{a vector of central frequencies per bin}

\item{alpha}{stretch factor}

\item{propagation}{the method for propagating phase: "time" = horizontal
propagation (default), "adaptive" = an experimental implementation of
"vocoder done right" (Prusa & Holighaus 2017)}

\item{tol}{tolerance of "vocoder done right" algorithm}

\item{nr, nc}{dimensions of input spectrogram}
}
\description{
Internal soundgen function called by pitchShift().
}
\keyword{internal}
