% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign-age-groups.R
\name{assign_age_groups}
\alias{assign_age_groups}
\title{Assign age groups in survey data}
\usage{
assign_age_groups(
  survey,
  age_limits = NULL,
  estimated_participant_age = c("mean", "sample", "missing"),
  estimated_contact_age = c("mean", "sample", "missing"),
  missing_participant_age = c("remove", "keep"),
  missing_contact_age = c("remove", "sample", "keep", "ignore")
)
}
\arguments{
\item{survey}{a \code{\link[=survey]{survey()}} object}

\item{age_limits}{lower limits of the age groups over which to construct
the matrix. Defaults to NULL. If NULL, age limits are inferred from
participant and contact ages.}

\item{estimated_participant_age}{if set to "mean" (default), people whose
ages are given as a range (in columns named "..._est_min" and
"..._est_max") but not exactly (in a column named "..._exact") will have
their age set to the mid-point of the range; if set to "sample", the age
will be sampled from the range; if set to "missing", age ranges will be
treated as missing}

\item{estimated_contact_age}{if set to "mean" (default), contacts whose ages
are given as a range (in columns named "..._est_min" and "..._est_max") but
not exactly (in a column named "..._exact") will have their age set to the
mid-point of the range; if set to "sample", the age will be sampled from
the range; if set to "missing", age ranges will be treated as missing}

\item{missing_participant_age}{if set to "remove" (default), participants
without age information are removed; if set to "keep", participants with
missing age are kept and treated as a separate age group}

\item{missing_contact_age}{if set to "remove" (default), participants that
have contacts without age information are removed; if set to "sample",
contacts without age information are sampled from all the contacts of
participants of the same age group; if set to "keep", contacts with missing
age are kept and treated as a separate age group; if set to "ignore",
contact with missing age are ignored in the contact analysis}
}
\value{
The survey object with processed age data.
}
\description{
This function processes age data in a survey object. It imputes ages from
ranges, handles missing values, and assigns age groups.
}
\examples{
polymod_grouped <- assign_age_groups(polymod)
polymod_grouped
polymod_custom <- assign_age_groups(polymod, age_limits = c(0, 5, 10, 15))
polymod_custom
}
