% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sma.R
\name{sma}
\alias{sma}
\title{Simple Moving Average}
\usage{
sma(data, order = NULL, ic = c("AICc", "AIC", "BIC"), h = 10,
  holdout = FALSE, cumulative = FALSE, intervals = c("none", "parametric",
  "semiparametric", "nonparametric"), level = 0.95, silent = c("all",
  "graph", "legend", "output", "none"), ...)
}
\arguments{
\item{data}{Vector or ts object, containing data needed to be forecasted.}

\item{order}{Order of simple moving average. If \code{NULL}, then it is
selected automatically using information criteria.}

\item{ic}{The information criterion used in the model selection procedure.}

\item{h}{Length of forecasting horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{cumulative}{If \code{TRUE}, then the cumulative forecast and prediction
intervals are produced instead of the normal ones. This is useful for
inventory control systems.}

\item{intervals}{Type of intervals to construct. This can be:

\itemize{
\item \code{none}, aka \code{n} - do not produce prediction
intervals.
\item \code{parametric}, \code{p} - use state-space structure of ETS. In
case of mixed models this is done using simulations, which may take longer
time than for the pure additive and pure multiplicative models.
\item \code{semiparametric}, \code{sp} - intervals based on covariance
matrix of 1 to h steps ahead errors and assumption of normal / log-normal
distribution (depending on error type).
\item \code{nonparametric}, \code{np} - intervals based on values from a
quantile regression on error matrix (see Taylor and Bunn, 1999). The model
used in this process is e[j] = a j^b, where j=1,..,h.
}
The parameter also accepts \code{TRUE} and \code{FALSE}. The former means that
parametric intervals are constructed, while the latter is equivalent to
\code{none}.}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{silent}{If \code{silent="none"}, then nothing is silent, everything is
printed out and drawn. \code{silent="all"} means that nothing is produced or
drawn (except for warnings). In case of \code{silent="graph"}, no graph is
produced. If \code{silent="legend"}, then legend of the graph is skipped.
And finally \code{silent="output"} means that nothing is printed out in the
console, but the graph is produced. \code{silent} also accepts \code{TRUE}
and \code{FALSE}. In this case \code{silent=TRUE} is equivalent to
\code{silent="all"}, while \code{silent=FALSE} is equivalent to
\code{silent="none"}. The parameter also accepts first letter of words ("n",
"a", "g", "l", "o").}

\item{...}{Other non-documented parameters.  For example parameter
\code{model} can accept a previously estimated SMA model and use its
parameters.}
}
\value{
Object of class "smooth" is returned. It contains the list of the
following values:

\itemize{
\item \code{model} - the name of the estimated model.
\item \code{timeElapsed} - time elapsed for the construction of the model.
\item \code{states} - the matrix of the fuzzy components of ssarima, where
\code{rows} correspond to time and \code{cols} to states.
\item \code{transition} - matrix F.
\item \code{persistence} - the persistence vector. This is the place, where
smoothing parameters live.
\item \code{order} - order of moving average.
\item \code{initial} - Initial state vector values.
\item \code{initialType} - Type of initial values used.
\item \code{nParam} - table with the number of estimated / provided parameters.
If a previous model was reused, then its initials are reused and the number of
provided parameters will take this into account.
\item \code{fitted} - the fitted values of ETS.
\item \code{forecast} - the point forecast of ETS.
\item \code{lower} - the lower bound of prediction interval. When
\code{intervals=FALSE} then NA is returned.
\item \code{upper} - the higher bound of prediction interval. When
\code{intervals=FALSE} then NA is returned.
\item \code{residuals} - the residuals of the estimated model.
\item \code{errors} - The matrix of 1 to h steps ahead errors.
\item \code{s2} - variance of the residuals (taking degrees of freedom into
account).
\item \code{intervals} - type of intervals asked by user.
\item \code{level} - confidence level for intervals.
\item \code{cumulative} - whether the produced forecast was cumulative or not.
\item \code{actuals} - the original data.
\item \code{holdout} - the holdout part of the original data.
\item \code{ICs} - values of information criteria of the model. Includes AIC,
AICc and BIC.
\item \code{logLik} - log-likelihood of the function.
\item \code{cf} - Cost function value.
\item \code{cfType} - Type of cost function used in the estimation.
\item \code{accuracy} - vector of accuracy measures for the
holdout sample. Includes: MPE, MAPE, SMAPE, MASE, sMAE, RelMAE, sMSE and
Bias coefficient (based on complex numbers). This is available only when
\code{holdout=TRUE}.
}
}
\description{
Function constructs State-Space simple moving average of predefined order
}
\details{
The function constructs AR model in the Single Source of Error State-space form
based on the idea that:

\eqn{y_{t} = \frac{1}{n} \sum_{j=1}^n y_{t-j}}

which is AR(n) process, that can be modelled using:

\eqn{y_{t} = w' v_{t-1} + \epsilon_{t}}

\eqn{v_{t} = F v_{t-1} + g \epsilon_{t}}

Where \eqn{v_{t}} is a state vector.
}
\examples{

# SMA of specific order
ourModel <- sma(rnorm(118,100,3),order=12,h=18,holdout=TRUE,intervals="p")

# SMA of arbitrary order
ourModel <- sma(rnorm(118,100,3),h=18,holdout=TRUE,intervals="sp")

summary(ourModel)
forecast(ourModel)
plot(forecast(ourModel))

}
\references{
\itemize{
\item Svetunkov I. (2017). Statistical models underlying functions of 'smooth'
package for R. Working Paper of Department of Management Science, Lancaster
University 2017:1, 1-52.
}
}
\seealso{
\code{\link[forecast]{ma}, \link[smooth]{es},
\link[smooth]{ssarima}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{ARIMA}
\keyword{SARIMA}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
