% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_trial_sequential_analysis.R
\name{DoTSA}
\alias{DoTSA}
\title{Trial sequential analysis.}
\usage{
DoTSA(
  data = NULL,
  source = NULL,
  time = NULL,
  n = NULL,
  es = NULL,
  se = NULL,
  r1 = NULL,
  m1 = NULL,
  sd1 = NULL,
  n1 = NULL,
  r2 = NULL,
  m2 = NULL,
  sd2 = NULL,
  n2 = NULL,
  group = c("Group 1", "Group 2"),
  ref = 2,
  prefer = "small",
  measure = "ES",
  model = "random",
  method = "DL",
  pooling = "IV",
  trnsfrm = "logit",
  poolProp = "IV",
  alpha = 0.05,
  beta = 0.2,
  PES = NULL,
  RRR = NULL,
  PV = "post-hoc",
  adjust = "D2",
  plot = FALSE,
  id = FALSE,
  invert = FALSE,
  smooth = FALSE,
  SAP = FALSE,
  BSB = FALSE
)
}
\arguments{
\item{data}{DATAFRAME consists of relevant information.}

\item{source}{CHARACTER for labeling the included data sets.}

\item{time}{NUMERIC values of time sequence.}

\item{n}{INTEGER values of sample sizes.}

\item{es}{NUMERIC values of effect sizes.}

\item{se}{NUMERIC values of standard errors for the effect sizes.}

\item{r1}{INTEGER values of observed events in group 1 in the included data.}

\item{m1}{NUMERIC values of estimated means in group 1 in the included data.}

\item{sd1}{NUMERIC values of standard deviations in group 1 in the
included data.}

\item{n1}{INTEGER values of sample sizes in group 1 in the included data.}

\item{r2}{INTEGER values of observed events in group 2 in the included data.}

\item{m2}{NUMERIC values of estimated means in group 2 in the included data.}

\item{sd2}{NUMERIC values of standard deviations in group 2 in the
included data.}

\item{n2}{INTEGER values of sample sizes in group 2 in the included data.}

\item{group}{CHARACTER for labeling two groups.}

\item{ref}{NUMERIC values of 1 or 2 for indicating group 1 or 2 as reference.}

\item{prefer}{CHARACTER of "small" and "large" for indicating which direction
is beneficial effect in statistic test.}

\item{measure}{CHARACTER for indicating which statistic measure should be used.}

\item{model}{CHARACTER of "random" and "fixed" for indicating whether
to use random-effects model or fixed-effect model.}

\item{method}{CHARACTER for indicating which estimator should be used in
random-effects model. In addition to the default "DL" method,
the current version also supports "REML" and "PM" methods for
calculating heterogeneity estimator.}

\item{pooling}{CHARACTER for indicating which method has to be used for pooling
binary data. Besides, current version also supports "MH" and
"Peto" for binary data pooling.}

\item{trnsfrm}{CHARACTER for indicating which method for transforming pooled
proportion. Current version supports "none", "logit", "log",
"arcsine", and "DAT" for the transformation.}

\item{poolProp}{CHARACTER for indicating which method has to be used for pooling
proportion. Current version supports "IV" and "GLMM" for the
data pooling.}

\item{alpha}{NUMERIC value between 0 to 1 for indicating the assumed type I
error.}

\item{beta}{NUMERIC value between 0 to 1 for indicating the assumed type II
error.}

\item{PES}{NUMERIC value for indicating the presumed meaningful effect size.}

\item{RRR}{NUMERIC value between 0 and 1 for indicating the presumed relative
risk reduction. This parameter only works for dichotomous outcome
by replacing parameter \code{PES}.}

\item{PV}{NUMERIC value for indicating the presumed variance of the
meaningful effect size. Current version allows a numeric value,
"post-hoc", and "PES" based on different considerations.}

\item{adjust}{CHARACTER for indicating how to adjust optimal information size.
Current version consists of "none", "D2", "I2", "CHL", "CHM", and
"CHH" for the adjustment.}

\item{plot}{LOGIC value for indicating whether to illustrate alpha-spending
monitoring plot.}

\item{id}{LOGIC value for indicating whether to label each data source.}

\item{invert}{LOGIC value for indicating whether to invert plot.}

\item{smooth}{LOGIC value for indicating whether to smooth error boundaries.}

\item{SAP}{LOGIC value for indicating whether to show sequential-adjusted
power.}

\item{BSB}{LOGIC value for indicating whether to illustrate beta-spending
boundaries.}
}
\value{
\strong{DoTSA()} returns a summary on the result of sequential analysis, and can be
stored as an object in \code{DoTSA} class. Explanations of returned information are
listed as follows:

\item{studies}{Numbers of studies included in the sequential analysis.}
\item{AIS}{Acquired information size refers to the total sample size in the
sequential analysis.}
\item{alpha}{A numeric value of type I error for the sequential analysis.}
\item{beta}{A numeric value of type II error for the sequential analysis.}
\item{PES}{A numeric value of presumed meaningful effect size for the
sequential analysis.}
\item{RRR}{A numeric value of relative risk reduction.}
\item{variance}{A numeric value of presumed variance of the meaningful effect
size for the sequential analysis.}
\item{diversity}{A numeric value to show diversity in the pooled analysis.}
\item{AF}{A numeric value of adjustment factor.}
\item{RIS.org}{A numeric value for required information size without adjustment.}
\item{RIS.adj}{A numeric value for adjusted required information size.}
\item{frctn}{A vector of fraction of each study included in the sequential
analysis.}
\item{weight}{A vector of weight of each study included in the sequential
analysis.}
\item{es.cum}{A vector of cumulative effect size in the sequential analysis.}
\item{se.cum}{A vector of standard error for the cumulative effect size in the
sequential analysis.}
\item{zval.cum}{A vector of cumulative z-value in the sequential analysis.}
\item{asb}{A data frame of alpha-spending values for each study.}
\item{aslb}{A numeric value for lower alpha-spending boundary.}
\item{asub}{A numeric value for upper alpha-spending boundary.}
}
\description{
\strong{DoTSA()} is a function for conducting trial sequential analysis.
}
\details{
\enumerate{
\item Basic information for the function \strong{DoTSA()}:
\strong{DoTSA()} supports sequential analysis of aggregate data synthesis based on
head-to-head comparison using either binary or continuous data in each group.
Minimum information for the function \strong{DoTSA()} encompasses a data set of
study-level data, and information for analysis settings in terms of time
sequence, presumed meaningful effect size, and presumed variance of the
meaningful effect size. Operative points of using function \strong{DoTSA()} are listed
below:
}

1.1. Parameter \code{data} should be used for assigning a data set.
1.2. Study-level data have to be assigned according to outcome type:
1.2.1. \strong{For dichotomous outcome}: Parameter \code{n1} and \code{n2} should be defined
with parameter \code{r1} and \code{r2}.
1.2.2. \strong{For continuous outcome}: parameter \code{n1} and \code{n2} should be defined
with parameter \code{m1}, \code{sd1}, \code{m2}, \code{sd2}.
1.3. Parameter \code{source}, \code{time}, \code{PES}, and \code{PV} are required for conducting
sequential analysis. Other parameters are auxiliary.
\enumerate{
\item Default in the function \strong{DoTSA()}
Certain defaults have been elucidated in the introductory section about the
parameters, but some of them need to be elaborated upon due to their complexity.
}

2.1. Default on the parameter \code{measure} is \code{"ES"} that automatically uses risk
ratio ("RR") for binary outcome and mean difference ("MD") for continuous
outcome respectively. Argument \code{"OR"} and \code{"SMD"} can be used for the parameter
\code{measure} when original analysis pools data based on odds ratio or standardized
mean difference.

2.2. Default on the parameter \code{method} is \code{"DL"} for applying DerSimonian-Laird
heterogeneity estimator in the original pooled analysis. Other eligible arguments
for the parameter are \code{"REML"} for restricted maximum-likelihood estimator,
\code{"PM"} for Paule-Mandel estimator, \code{"ML"} for maximum-likelihood estimator,
\code{"HS"} for Hunter-Schmidt estimator, \code{"SJ"} for Sidik-Jonkman estimator,
\code{"HE"} for Hedges estimator, and \code{"EB"} for empirical Bayes estimator.

2.3. Default on the parameter \code{pooling} is \code{"IV"} for applying inverse variance
weighting method. Other commonly-used and eligible arguments for the parameter
are \code{"MH"} for Mantel-Haenszel method and \code{"Peto"} for pooling data using Peto
method. The arguments \code{"MH"} and \code{"Peto"} are exclusively available for binary
outcomes, while the argument \code{"IV"} will be automatically applied in the case
of continuous outcomes.

2.4. Default on the parameter \code{adjust} is \code{"D2"} for adjusting required
information size (RIS) based on diversity (D-squared statistics). Other eligible
arguments for the parameter are \code{"None"} for the RIS without adjustment, \code{"I2"}
for adjusted RIS based on I-squared statistics, \code{"CHL"} for adjusted RIS based
on low heterogeneity by multiplying 1.33, \code{"CHM"} for adjusted RIS by multiplying
2 due to moderate heterogeneity, and \code{"CHL"} for adjusted RIS by multiplying
4 due to high heterogeneity.
}
\examples{
## Not run:
# 1. Import a dataset of study by Fleiss (1993)
library(meta)
data("Fleiss1993bin")

# 2. Perform trial sequential analysis
DoTSA(Fleiss1993bin, study, year,
      r1 = d.asp, n1 = n.asp,
      r2 = d.plac, n2 = n.plac,
      measure = "RR", RRR = 0.2,
      group = c("Aspirin", "Control"))

## End(Not run)

}
\references{
Jennison, C., & Turnbull, B. W. (2005). Meta-analyses and adaptive group
sequential designs in the clinical development process.
\strong{Journal of biopharmaceutical statistics}, \emph{15(4)}, 537–558.
https://doi.org/10.1081/BIP-200062273.

Wetterslev, J., Jakobsen, J. C., & Gluud, C. (2017). Trial sequential analysis
in systematic reviews with meta-analysis. \strong{BMC medical research methodology},
\emph{17(1)}, 1-18.

NCSS Statistical Software (2023). \strong{Group-sequential analysis for two proportions}.
In \emph{PASS Documentation}. Available online:
https://www.ncss.com/wp-content/themes/ncss/pdf/Procedures/NCSS/Group-Sequential_Analysis_for_Two_Proportions.pdf
}
\seealso{
\code{\link{PlotCoRNET}}
}
\author{
Enoch Kang
}
