% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smdi_summarize.R
\name{smdi_summarize}
\alias{smdi_summarize}
\title{Utility helper to give a light summary of partially observed covariates}
\usage{
smdi_summarize(data = NULL, covar = NULL, strata = NULL)
}
\arguments{
\item{data}{dataframe or tibble object with partially observed/missing variables. Assumes a a one-row-per-patient format.}

\item{covar}{character covariate or covariate vector with partially observed variable/column name(s) to investigate. If NULL, the function automatically includes all columns with at least one missing observation.}

\item{strata}{character name of variable/column by which results should be stratified}
}
\value{
returns count and proportion of missing values. If strata is specified, the returned proportion refers to the amount of
patients in the respective stratum.
}
\description{
This function takes a dataframe and automatically returns the amount and proportion of
missing for partially observed covariates assuming a one-row-per-patient
dataframe. This is an important utility function for other functions in this package.
Results can also be stratified by another variable
in which case the proportion missing refers to the amount of
patients in the respective stratum.
}
\examples{
library(smdi)

smdi_vis(data = smdi_data)

}
