% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statLearn.R
\name{impNA}
\alias{impNA}
\title{Impute Missing Values}
\usage{
impNA(x, fn = mean, ...)
}
\arguments{
\item{x}{A numeric vector}

\item{fn}{A function to apply to all values in the vector \code{x}}

\item{...}{Additional arguments to be passed to function \code{fn}}
}
\value{
Vector \code{x} with all missing values replaced
}
\description{
Replace missing values in a vector using a function (by default the mean) on 
this vector.
}
\examples{
v1=c(2,5,3,NA,2,4,1,NA)
#Replace values with the mean
impNA(v1,na.rm=TRUE)
#Replace values with the minimum
impNA(v1,min,na.rm=TRUE)
}
