% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{crossing2}
\alias{crossing2}
\title{Find Edge Crossings}
\usage{
crossing2(split, g)
}
\arguments{
\item{split}{a vector with a value for each vertex in \code{g}, indicating
the group each vertex belongs to}

\item{g}{an igraph object}
}
\value{
A logical vector indicating for each edge if it crosses groups or 
        not. For each edge that crosses, it is TRUE, otherwise it is FALSE.
}
\description{
Determine if edges in a graph cross groups or stay within groups. This is
similar to the crossings function in igraph, but uses a vector for the split
rather than a communities object.
}
\examples{
g=igraph::graph_from_literal(1-2,2-3:4,3-4:5:6,5-1)
split=c("A","A","B","B","A","B")
igraph::V(g);split
igraph::E(g);crossing2(split,g)
}
