% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_get_class.R
\name{sits_get_class}
\alias{sits_get_class}
\alias{sits_get_class.default}
\alias{sits_get_class.csv}
\alias{sits_get_class.shp}
\alias{sits_get_class.sf}
\alias{sits_get_class.sits}
\alias{sits_get_class.data.frame}
\title{Get values from classified maps}
\usage{
sits_get_class(cube, samples)

\method{sits_get_class}{default}(cube, samples)

\method{sits_get_class}{csv}(cube, samples)

\method{sits_get_class}{shp}(cube, samples)

\method{sits_get_class}{sf}(cube, samples)

\method{sits_get_class}{sits}(cube, samples)

\method{sits_get_class}{data.frame}(cube, samples)
}
\arguments{
\item{cube}{Classified data cube.}

\item{samples}{Location of the samples to be retrieved.
Either a tibble of class "sits", an "sf" object,
the name of a shapefile or csv file, or
a data.frame with columns "longitude" and "latitude"}
}
\value{
A tibble of with columns
                       <longitude, latitude, start_date, end_date, label>.
}
\description{
Given a set of lat/long locations and a classified cube,
retrieve the class of each point. This function is useful to obtain
values from classified cubes for accuracy estimates.
}
\note{
There are four ways of specifying data to be retrieved using the
\code{samples} parameter:
(a) CSV file: a CSV file with columns \code{longitude}, \code{latitude};
(b) SHP file: a shapefile in POINT geometry;
(c) sits object: A sits tibble;
(d) sf object: An \code{link[sf]{sf}} object with POINT or geometry;
(e) data.frame: A data.frame with \code{longitude} and \code{latitude}.
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # plot the probability cube
    plot(probs_cube)
    # smooth the probability cube using Bayesian statistics
    bayes_cube <- sits_smooth(probs_cube, output_dir = tempdir())
    # plot the smoothed cube
    plot(bayes_cube)
    # label the probability cube
    label_cube <- sits_label_classification(
        bayes_cube,
        output_dir = tempdir()
    )
    # obtain the a set of points for sampling
    ground_truth <- system.file("extdata/samples/samples_sinop_crop.csv",
        package = "sits"
    )
    # get the classification values for a selected set of locations
    labels_samples <- sits_get_class(label_cube, ground_truth)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
