% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-ssm-cov-y.R
\name{SSMCovY}
\alias{SSMCovY}
\title{Steady-State Covariance Matrix for the
Observed Variables in the
State Space Model}
\usage{
SSMCovY(lambda, theta, cov_eta)
}
\arguments{
\item{lambda}{Numeric matrix.
Factor loading matrix linking the latent variables
to the observed variables
(\eqn{\boldsymbol{\Lambda}}).}

\item{theta}{Numeric matrix.
The covariance matrix of
the measurement error
(\eqn{\boldsymbol{\Theta}}).}

\item{cov_eta}{Numeric matrix.
The steady-state covariance matrix
for the latent variables
in the state space model}
}
\description{
The steady-state covariance matrix
for the observed variables
in the state space model
\eqn{\mathrm{Cov} \left( \mathbf{y} \right)}
is given by
\deqn{
  \mathrm{Cov} \left( \mathbf{y} \right)
  =
  \boldsymbol{\Lambda}
  \mathrm{Cov} \left( \boldsymbol{\eta} \right)
  \boldsymbol{\Lambda}^{\prime}
  +
  \boldsymbol{\Theta}
}
where
\eqn{\boldsymbol{\Lambda}}
is the matrix of factor loadings,
\eqn{\boldsymbol{\Theta}}
is the covariance matrix of
the measurement error,
and
\eqn{\mathrm{Cov} \left( \boldsymbol{\eta} \right)}
is the steady-state covariance matrix
for the latent variables.
}
\examples{
beta <- matrix(
  data = c(
    0.7, 0.5, -0.1,
    0.0, 0.6, 0.4,
    0.0, 0.0, 0.5
  ),
  nrow = 3
)
psi <- 0.1 * diag(3)
lambda <- diag(3)
theta <- diag(3)
cov_eta <- SSMCovEta(
  beta = beta,
  psi = psi
)
SSMCovY(
  lambda = lambda,
  theta = theta,
  cov_eta = cov_eta
)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
