% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateMvGammaData.R
\name{generate_mvGamma_data}
\alias{generate_mvGamma_data}
\title{Generate Multivariate Skewed Gamma Transformed Data}
\usage{
generate_mvGamma_data(sampSize, sampCorr_mat, shape_num, rate_num)
}
\arguments{
\item{sampSize}{Number of samples to generate.}

\item{sampCorr_mat}{A correlation matrix for the normal distribution.}

\item{shape_num}{A numeric vector of shape parameters for the Gamma transformation.}

\item{rate_num}{A numeric vector of rate parameters for the Gamma transformation.
Second column: \url{https://en.wikipedia.org/wiki/Gamma_distribution}}
}
\value{
A data frame containing the transformed Gamma samples.
}
\description{
This function generates multivariate normal samples, transforms
them into Z-scores, and then calls the \code{qgamma()} function to transform the
values for each correlated variable to those from a Gamma distribution.
}
\examples{
p <- 4
N <- 1000
shapeGamma_num <- c(0.5, 0.75, 1, 1.25)
rateGamma_num <- 1:4
cov_mat <- diag(p)
generate_mvGamma_data(N, cov_mat, shapeGamma_num, rateGamma_num)
}
