% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimateMultivariateShapeRate.R
\name{estimate_mv_shape_rate}
\alias{estimate_mv_shape_rate}
\title{Helper function to estimate shape, rate, and correlation parameters for
observations within a group}
\usage{
estimate_mv_shape_rate(x_df, using = c("MoM", "gMLE"))
}
\arguments{
\item{x_df}{A numeric data frame with observations from ONE group}

\item{using}{which method will be used to estimate the multivariate Gamma
shape and rate parameters. Defaults to \code{"MoM"} (method of moments, which was
used in the author's paper), or \code{"gMLE"} (maximum likelihood estimates from
the Generalized Gamma distribution without bias correction).}
}
\value{
A list of estimated parameters for Multivariate Gamma distribution
(sample size, sample mean, sample correlation matrix \code{sampCorr_mat}, sample
shape vector \code{alpha}, sample rate vector \code{beta})
}
\description{
Helper function to estimate shape, rate, and correlation parameters for
observations within a group
}
\examples{
myData <- data.frame(
  VALUE1 = c(2.3, 2.7, 5),
  VALUE2 = c(4.5, 4.2, 9)
)
estimate_mv_shape_rate(myData)
}
