% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signs.R
\name{signs}
\alias{signs}
\title{Add proper minus signs}
\usage{
signs(x, ..., format = getOption("signs.format"),
  add_plusses = getOption("signs.add.plusses"),
  trim_leading_zeros = getOption("signs.trim.leading.zeros"),
  label_at_zero = getOption("signs.label.at.zero"))
}
\arguments{
\item{x}{Numeric vector.}

\item{...}{Other arguments passed on to \code{format}.}

\item{format}{Any function that takes a numeric vector
and returns a character vector,
such as \code{scales::number},
\code{scales::comma}, or
\code{scales::percent}
(all of which are documented at \code{\link[scales]{number_format}}).}

\item{add_plusses}{Logical. Should positive values have plus signs?}

\item{trim_leading_zeros}{Logical. Should \code{signs} trim leading zeros
from values of \code{x} between -1 and 1?}

\item{label_at_zero}{Character. What should be returned
when \code{x = 0}? Options \code{"none"} (no change),
\code{"blank"} (a zero-length string),
or \code{"symbol"} (add a plus-minus symbol).}
}
\value{
A \code{UTF-8} character vector
}
\description{
The true minus sign (Unicode 2212) --
neither an em dash, nor an en dash, nor the usual hyphen-minus --
is highly underrated.
It makes everything look better!
}
\details{
\code{add_plusses}, \code{trim_leading_zeros}, and \code{label_at_zero}
are offered for convenience.

The options \code{signs.format}, \code{signs.add.plusses},
\code{signs.trim.leading.zeros}, and \code{signs.label.at.zero}
are set when the package is loaded
to \code{scales::number}, \code{FALSE}, \code{FALSE}, and \code{"none"},
respectively.
If the package is not loaded and the these options are not otherwise set,
\code{signs} will use those defaults.

\code{label_at_zero} is applied \emph{after} \code{format};
that is, if it is \code{"blank"}
and you've specified an accuracy of \code{0.1},
\code{-0.04} will show as blank.
}
\examples{
x <- seq(-5, 5)
scales::number(x)
signs(x)
signs(x, accuracy = 1, scale = 1, format = scales::percent)
signs(x, add_plusses = TRUE)
signs(x, add_plusses = TRUE, label_at_zero = "blank")
signs(x, add_plusses = TRUE, label_at_zero = "symbol")
signs(x, accuracy = .1, scale = .1, trim_leading_zeros = TRUE)
}
