#' Wrapper for updating plotly with huge data
#'
#' @description
#' using this function, updater of the plotly with huge data is easily
#' installed.
#' @param session The \code{session} object passed to function given to
#' \code{shinyServer}.
#' @param outputId Character. The outputId of the plotly that will be
#' down-sampled
#' @param relayout_order Named list.
#' The list is generated by converging the dictionary
#' obtained from \code{plotlyjs_relayout}.
#' @param sd_obj The \code{shiny_downsampler} instance that is used for
#' generating the figure and contains the full data.
#' @export
#' @examples
#'\donttest{
#' data(noise_fluct)
#' fig <- plot_ly(x = d$x, y = d$y, type = "scatter", mode = "lines")
#'
#' shd <- shiny_downsampler$new(figure = fig)
#'
#' ui <- fluidPage(
#'   plotlyOutput(outputId = "hp", width = "800px", height = "600px")
#' )
#'
#' server <- function(input, output, session) {
#'
#'   output$hp <- renderPlotly(shd$figure)
#'
#'   observeEvent(plotly::event_data("plotly_relayout"),{
#'     updatePlotlyH(session, "hp", plotly::event_data("plotly_relayout"), shd)
#'   })
#'
#' }
#'
#' shinyApp(ui = ui, server = server)
#'}
updatePlotlyH <- function(session, outputId, relayout_order, sd_obj) {
  sd_obj$update_figure_data(relayout_order)
  figure_data <- sd_obj$get_figure_data()
  plotlyProxy(outputId, session) %>%
    plotlyProxyInvoke(
      "deleteTraces", seq_along(figure_data) - 1
    ) %>%
    plotlyProxyInvoke(
      "addTraces",
      figure_data
    )
}
