% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlock.R
\name{unlockKeys}
\alias{unlockKeys}
\title{Open an API key and use it build a connection.}
\usage{
unlockKeys(
  connections,
  keyring,
  connectFUN = NULL,
  envir = NULL,
  passwordFUN = .default_pass(),
  service = "shelter",
  ...
)
}
\arguments{
\item{connections}{character vector. A list of strings that define the
connections with associated API_KEYs to load into environment. Each
name should correspond to a REDCap project for traceability, but
it can be named anything one desires.
The name in the returned list is this name.}

\item{keyring}{character. Potential keyring, not used by default.}

\item{connectFUN}{function or list(function). A function that takes a key and returns a connection.
the function should call `stop` if the key is invalid in some manner. The
first argument of the function is the API key. The validation of the
key via a connection test is important for the full user interaction
algorithm to work properly. If one wished to just retrieve an API key
and not test the connection this would work `function(x, ...) x`, but
be aware that if the key is invalid it will not query the user as
the validity is not tested.}

\item{envir}{environment. The target environment for the connections. Defaults to NULL
which returns the keys as a list. Use [globalenv()] to assign in the
global environment. Will accept a number such a '1' for global as well.}

\item{passwordFUN}{function. Function to get the password for the keyring. Usually defaults `getPass::getPass`.
On MacOS it will use rstudioapi::askForPassword if available.}

\item{service}{character(1). The keyring service. Defaults to package name.}

\item{\dots}{Additional arguments passed to `connectFUN()`.}
}
\value{
If `envir` is NULL returns a list of opened connections. Otherwise
        connections are assigned into the specified `envir`.
}
\description{
Opens a set of connections  from API keys stored in an encrypted keyring.
If the keyring does not exist, it will ask for password to this keyring to use on
later requests. Next it
will ask for the API keyss specified in `connections`. If an API key does not
work, it will request again. On later executions it will use an open keyring
to retrieve all API_KEYs or for a password if the keyring is currently
locked.
}
\details{
If one forgets the password to this keyring, or wishes to start over:
`keyring_delete("<NAME_OF_KEY_RING_HERE>")`

For production servers where the password must be stored in a readable
plain text file, it will search for `../<basename>.yml`. DO NOT USE
this unless one is a sysadmin on a production hardened system, as this defeats the security and purpose of
a local encrypted file. The expected structure of this yaml file is
as follows:

\preformatted{
other-config-stuff1: blah blah
shelter:
  keys:
    intake: THIS_IS_THE_INTAKE_DATABASE_APIKEY
    details: THIS_IS_THE_DETAILS_DATABASE_APIKEY
other-config-stuff2: blah blah
other-config-stuff3: blah blah
}

For production servers the use of ENV variables is also supported. The connection
string is converted to upper case for the search of ENV. If a YAML file
and ENV definitions both exist, the YAML will take precedence.

IMPORTANT: Make sure that R is set to NEVER save workspace to .RData
as this *is* writing the API_KEY to a local file in clear text because
connection objects contain the unlocked key in memory. One can use the
following in .Rprofile, `usethis::edit_r_profile()`:
\preformatted{
newfun <- function (save = "no", status = 0, runLast = TRUE)
  .Internal(quit(save, status, runLast))
pkg <- 'base'
oldfun <- 'q'
pkgenv <- as.environment(paste0("package:", pkg))
unlockBinding(oldfun, pkgenv)
utils::assignInNamespace(oldfun, newfun, ns = pkg, envir = pkgenv)
assign(oldfun, newfun, pkgenv)
lockBinding(oldfun, pkgenv)
}
}
\examples{
\dontrun{
unlockKeys(c(test_conn    = 'Testshelter',
             sandbox_conn = 'SandboxAPI'),
             keyring      = '<NAME_OF_KEY_RING_HERE>',
             envir        = globalenv(),
             passwordFUN  = function(x, ...) x)
}
}
