% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterateHydOrder.R
\name{iterateHydOrder}
\alias{iterateHydOrder}
\title{Iteratively Attempt Hydrologic Ordering of Geomorphic Proportion Matrix}
\usage{
iterateHydOrder(
  x,
  g,
  target = 0.9,
  maxIter = 20,
  j.amount = 0.05,
  verbose = FALSE,
  trace = FALSE
)
}
\arguments{
\item{x}{\code{data.frame} geomorphic proportion matrix, as created by \code{soilDB::fetchOSD(..., extended=TRUE)}}

\item{g}{name of geomorphic summary table, one of: \code{c('geomcomp', 'hillpos', 'flats', 'terrace', 'mtnpos', 'shape')}}

\item{target}{numeric, target match rate}

\item{maxIter}{integer, maximum number of perturbations of geomorphic probability matrix}

\item{j.amount}{numeric, amount of noise applied to rows with too few unique values, passed to \code{jitter()}}

\item{verbose}{logical, additional output printed via message}

\item{trace}{logical, additional list of results for each iteration}
}
\value{
A \code{list} with the following elements:
\itemize{
\item \code{clust}: rotated \code{hclust} object
\item \code{hyd.order}: vector of series names, in hydrologic ordering
\item \code{clust.hyd.order}: vector of series names, after clustering + rotation, approximate hydrologic ordering
\item \code{match.rate}: fraction of series matching target hydrologic ordering, after clustering + rotation
\item \code{obj}: objective function value (sum of squared rank differences), used by \code{\link[=iterateHydOrder]{iterateHydOrder()}}
\item \code{niter}: number of iterations
\item \code{trace}: list of results by iteration, only when \code{trace = TRUE}
}
}
\description{
Iteratively Attempt Hydrologic Ordering of Geomorphic Proportion Matrix
}
\details{
This function is used by the suite of geomorphic proportion visualization functions (\verb{viz*}) to attempt rotation of a dendrogram according to "hydrologic ordering" rules. A perfect rotation is not always possible, and reported as a match rate in the returned \code{score} value
}
\examples{

# example data, similar to results from soilDB::fetchOSD(..., extended = TRUE)
data("OSDexamples")

# single iteration of hydrologic ordering
h1 <- hydOrder(OSDexamples$hillpos, g = 'hillpos', clust = TRUE)

# perform several iterations, keep the best one
h2 <- iterateHydOrder(OSDexamples$hillpos, 'hillpos', verbose = TRUE)

# compare: only slightly better match rate achieved
h1$match.rate
h2$match.rate

# return trace log for eval of objective function
# increase max iterations
h2 <- iterateHydOrder(OSDexamples$hillpos, 'hillpos', maxIter = 100, verbose = TRUE, trace = TRUE)

# inspect objective function evolution
tr <- h2$trace
obj <- sapply(tr, '[[', 'obj')

plot(obj, type = 'b')
hist(obj)

# in this case the clustering of hillpos proportions has only two possible configurations

}
\author{
D.E. Beaudette
}
