% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateColorPlot.R
\name{aggregateColorPlot}
\alias{aggregateColorPlot}
\title{Plot aggregate soil color data}
\usage{
aggregateColorPlot(
  x,
  print.label = TRUE,
  label.font = 1,
  label.cex = 0.65,
  label.orientation = c("v", "h"),
  buffer.pct = 0.02,
  print.n.hz = FALSE,
  rect.border = "black",
  horizontal.borders = FALSE,
  horizontal.border.lwd = 2,
  x.axis = TRUE,
  y.axis = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{list}, results from \code{aqp::aggregateColor()}}

\item{print.label}{logical, print Munsell color labels inside of rectangles, only if they fit}

\item{label.font}{font specification for color labels}

\item{label.cex}{font size for color labels}

\item{label.orientation}{label orientation, \code{v} for vertical or \code{h} for horizontal}

\item{buffer.pct}{extra space between labels and color rectangles}

\item{print.n.hz}{optionally print the number of horizons below Munsell color labels}

\item{rect.border}{color for rectangle border}

\item{horizontal.borders}{optionally add horizontal borders between bands of color}

\item{horizontal.border.lwd}{line width for horizontal borders}

\item{x.axis}{logical, add a scale and label to x-axis?}

\item{y.axis}{logical, add group labels to y-axis?}

\item{...}{additional arguments passed to \code{plot}}
}
\value{
nothing, function called for graphical output
}
\description{
Generate a plot from summaries generated by \code{aqp::aggregateColor()}.
}
\details{
Tutorial at \url{http://ncss-tech.github.io/AQP/sharpshootR/aggregate-soil-color.html}.
}
\examples{

\donttest{

if(require(aqp) &
   require(soilDB)) {
  
  data(loafercreek, package = 'soilDB')
  
  # generalize horizon names using REGEX rules
  n <- c('Oi', 'A', 'BA','Bt1','Bt2','Bt3','Cr','R')
  p <- c('O', '^A$|Ad|Ap|AB','BA$|Bw', 
         'Bt1$|^B$','^Bt$|^Bt2$','^Bt3|^Bt4|CBt$|BCt$|2Bt|2CB$|^C$','Cr','R')
  loafercreek$genhz <- generalize.hz(loafercreek$hzname, n, p)
  
  # remove non-matching generalized horizon names
  loafercreek$genhz[loafercreek$genhz == 'not-used'] <- NA
  loafercreek$genhz <- factor(loafercreek$genhz)
  
  # aggregate color data, this function is from the `aqp` package
  a <- aggregateColor(loafercreek, 'genhz')
  
  # plot
  op <- par(no.readonly = TRUE)
  
  par(mar=c(4,4,1,1))
  
  # vertical labels, the default
  aggregateColorPlot(a, print.n.hz = TRUE)
  
  # horizontal labels
  aggregateColorPlot(a, print.n.hz = TRUE, label.orientation = 'h')
  
  par(op)
  
}

}
}
\author{
D.E. Beaudette
}
\keyword{hplots}
