% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{plot_vaeac_imputed_ggpairs}
\alias{plot_vaeac_imputed_ggpairs}
\title{Plot Pairwise Plots for Imputed and True Data}
\usage{
plot_vaeac_imputed_ggpairs(
  explanation,
  which_vaeac_model = "best",
  x_true = NULL,
  add_title = TRUE,
  alpha = 0.5,
  upper_cont = c("cor", "points", "smooth", "smooth_loess", "density", "blank"),
  upper_cat = c("count", "cross", "ratio", "facetbar", "blank"),
  upper_mix = c("box", "box_no_facet", "dot", "dot_no_facet", "facethist",
    "facetdensity", "denstrip", "blank"),
  lower_cont = c("points", "smooth", "smooth_loess", "density", "cor", "blank"),
  lower_cat = c("facetbar", "ratio", "count", "cross", "blank"),
  lower_mix = c("facetdensity", "box", "box_no_facet", "dot", "dot_no_facet",
    "facethist", "denstrip", "blank"),
  diag_cont = c("densityDiag", "barDiag", "blankDiag"),
  diag_cat = c("barDiag", "blankDiag"),
  cor_method = c("pearson", "kendall", "spearman")
)
}
\arguments{
\item{explanation}{Shapr list. The output list from the \code{\link[=explain]{explain()}} function.}

\item{which_vaeac_model}{String. Indicating which \code{vaeac} model to use when generating the samples.
Possible options are always \code{'best'}, \code{'best_running'}, and \code{'last'}. All possible options can be obtained
by calling \code{names(explanation$internal$parameters$vaeac$models)}.}

\item{x_true}{Data.table containing the data from the distribution that the \code{vaeac} model is fitted to.}

\item{add_title}{Logical. If \code{TRUE}, then a title is added to the plot based on the internal description
of the \code{vaeac} model specified in \code{which_vaeac_model}.}

\item{alpha}{Numeric between \code{0} and \code{1} (default is \code{0.5}). The degree of color transparency.}

\item{upper_cont}{String. Type of plot to use in upper triangle for continuous features, see \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Possible options are: \code{'cor'} (default), \code{'points'}, \code{'smooth'}, \code{'smooth_loess'}, \code{'density'}, and \code{'blank'}.}

\item{upper_cat}{String. Type of plot to use in upper triangle for categorical features, see \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Possible options are: \code{'count'} (default), \code{'cross'}, \code{'ratio'}, \code{'facetbar'}, and \code{'blank'}.}

\item{upper_mix}{String. Type of plot to use in upper triangle for mixed features, see \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Possible options are: \code{'box'} (default), \code{'box_no_facet'}, \code{'dot'}, \code{'dot_no_facet'}, \code{'facethist'},
\code{'facetdensity'}, \code{'denstrip'}, and \code{'blank'}}

\item{lower_cont}{String. Type of plot to use in lower triangle for continuous features, see \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Possible options are: \code{'points'} (default), \code{'smooth'}, \code{'smooth_loess'}, \code{'density'}, \code{'cor'}, and \code{'blank'}.}

\item{lower_cat}{String. Type of plot to use in lower triangle for categorical features, see \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Possible options are: \code{'facetbar'} (default), \code{'ratio'}, \code{'count'}, \code{'cross'}, and \code{'blank'}.}

\item{lower_mix}{String. Type of plot to use in lower triangle for mixed features, see \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Possible options are: \code{'facetdensity'} (default), \code{'box'}, \code{'box_no_facet'}, \code{'dot'}, \code{'dot_no_facet'},
\code{'facethist'}, \code{'denstrip'}, and \code{'blank'}.}

\item{diag_cont}{String. Type of plot to use on the diagonal for continuous features, see \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Possible options are: \code{'densityDiag'} (default), \code{'barDiag'}, and \code{'blankDiag'}.}

\item{diag_cat}{String. Type of plot to use on the diagonal for categorical features, see \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Possible options are: \code{'barDiag'} (default) and \code{'blankDiag'}.}

\item{cor_method}{String. Type of correlation measure, see \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Possible options are: \code{'pearson'} (default), \code{'kendall'}, and \code{'spearman'}.}
}
\value{
A \code{\link[GGally:ggpairs]{GGally::ggpairs()}} figure.
}
\description{
A function that creates a matrix of plots (\code{\link[GGally:ggpairs]{GGally::ggpairs()}}) from
generated imputations from the unconditioned distribution \eqn{p(\boldsymbol{x})} estimated by
a \code{vaeac} model, and then compares the imputed values with data from the true distribution (if provided).
See \href{https://www.blopig.com/blog/2019/06/a-brief-introduction-to-ggpairs/}{ggpairs} for an
introduction to \code{\link[GGally:ggpairs]{GGally::ggpairs()}}, and the corresponding
\href{https://ggobi.github.io/ggally/articles/ggally_plots.html}{vignette}.
}
\examples{
\donttest{

if (requireNamespace("xgboost", quietly = TRUE) &&
  requireNamespace("ggplot2", quietly = TRUE) &&
  requireNamespace("torch", quietly = TRUE) &&
  torch::torch_is_installed()) {
  data("airquality")
  data <- data.table::as.data.table(airquality)
  data <- data[complete.cases(data), ]

  x_var <- c("Solar.R", "Wind", "Temp", "Month")
  y_var <- "Ozone"

  ind_x_explain <- 1:6
  x_train <- data[-ind_x_explain, ..x_var]
  y_train <- data[-ind_x_explain, get(y_var)]
  x_explain <- data[ind_x_explain, ..x_var]

  # Fitting a basic xgboost model to the training data
  model <- xgboost::xgboost(
    x = x_train,
    y = y_train,
    nround = 100,
    verbosity = 0
  )

  explanation <- shapr::explain(
    model = model,
    x_explain = x_explain,
    x_train = x_train,
    approach = "vaeac",
    phi0 = mean(y_train),
    n_MC_samples = 1,
    vaeac.epochs = 10,
    vaeac.n_vaeacs_initialize = 1
  )

  # Plot the results
  figure <- shapr::plot_vaeac_imputed_ggpairs(
    explanation = explanation,
    which_vaeac_model = "best",
    x_true = x_train,
    add_title = TRUE
  )
  figure

  # Note that this is an ggplot2 object which we can alter, e.g., we can change the colors.
  figure +
    ggplot2::scale_color_manual(values = c("#E69F00", "#999999")) +
    ggplot2::scale_fill_manual(values = c("#E69F00", "#999999"))
}
}
}
\references{
\itemize{
\item \href{https://www.jmlr.org/papers/volume23/21-1413/21-1413.pdf}{
Olsen, L. H., Glad, I. K., Jullum, M., & Aas, K. (2022). Using Shapley values and variational autoencoders to
explain predictive models with dependent mixed features. Journal of machine learning research, 23(213), 1-51}
}
}
\author{
Lars Henry Berge Olsen
}
