% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_map.R
\name{strat_map}
\alias{strat_map}
\title{Map a raster stack of a list of rasters}
\usage{
strat_map(
  sraster,
  stack = FALSE,
  filename = NULL,
  overwrite = FALSE,
  plot = FALSE,
  details = FALSE
)
}
\arguments{
\item{sraster}{spatRaster or list. Stratification raster stack or list of rasters. If \code{sraster}
is of class \code{list}, then it is internally converted into a raster stack.}

\item{stack}{Logical. Default = \code{FALSE}. If \code{TRUE}, inputs and output will be stacked:
\code{strata_1, strata_2, ..., strata}.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}

\item{plot}{Logical. Plots output strata raster and visualized
strata with boundary dividers.}

\item{details}{Logical. If \code{FALSE} (default) output is a mapped stratified spatRaster object.
If \code{TRUE} return a list where \code{$outRaster} is the mapped stratified raster, and
\code{$lookUp} is the lookup table for the stratification.}
}
\value{
A spatRaster object.
}
\description{
Map stratified rasters to a combined stratification.
}
\section{Mapping}{

The mapping algorithm will take the stratification from \code{sraster} and combine it with
overlying strata values across all layers. This will result in a \code{strata} attribute
where the values from all inputs are combined.

i.e.

If \code{strata_1 = 1} and \code{strata_2 = 1} then \code{strata = 11}.

If \code{strata_1 = 2} and \code{strata_2 = 14} then \code{strata = 214}.

If \code{strata_1 = "A"} and \code{strata_2 = 14} then \code{strata = "A14"}.
}

\examples{
#--- load input metrics rasters ---#
raster <- system.file("extdata", "sraster.tif", package = "sgsR")
sraster <- terra::rast(raster)

#--- read polygon coverage ---#
poly <- system.file("extdata", "inventory_polygons.shp", package = "sgsR")
fri <- sf::st_read(poly)

#--- stratify polygon coverage ---#
#--- specify polygon attribute to stratify ---#

attribute <- "NUTRIENTS"

#--- specify features within attribute & how they should be grouped ---#
#--- as a single vector ---#

features <- c("poor", "rich", "medium")

srasterfri <- strat_poly(
  poly = fri,
  attribute = attribute,
  features = features,
  raster = sraster
)

#--- map srasters with raster stack ---#
stack <- c(srasterfri, sraster)
strat_map(
  sraster = stack
)

#--- map sraster with list of rasters ---#
rast_list <- list(srasterfri, sraster)
strat_map(
  sraster = rast_list,
  stack = TRUE,
  details = TRUE
)
}
\seealso{
Other stratify functions: 
\code{\link{strat_breaks}()},
\code{\link{strat_kmeans}()},
\code{\link{strat_poly}()},
\code{\link{strat_quantiles}()}
}
\author{
Tristan R.H. Goodbody, Tommaso Trotto, Robert Hijmans
}
\concept{stratify functions}
