% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_sampsize.R
\name{calculate_sampsize}
\alias{calculate_sampsize}
\title{Sample size determination}
\usage{
calculate_sampsize(
  mraster,
  rse = NULL,
  start = 0.01,
  end = 0.05,
  increment = 0.001,
  plot = FALSE
)
}
\arguments{
\item{mraster}{spatRaster. Metrics raster. All values must be numeric.}

\item{rse}{Numeric. Desired relative standard error (coefficient of variation of the mean)
threshold to determine sample size.}

\item{start}{Numeric. First rse value to begin rse sequence. default = \code{0.01}.}

\item{end}{Numeric. Final rse value to end rse sequence. default = \code{0.05}.}

\item{increment}{Numeric. Value to increment between \code{start} & \code{end}. default = \code{0.001}.}

\item{plot}{Logical. if \code{TRUE} output graphical representation of estimated sample size vs. rse.}
}
\value{
A data.frame of sample size and rse by raster variable.
}
\description{
Determine a samples size for simple random sampling using relative standard error
}
\note{
\deqn{rse = (100 * SE) / mean)}

Where:

\itemize{
 \item{SE}{ - Standard error of the mean}
 \item{s}{ - Standard deviation of the observations}
 \item{n}{ - Number of observations}
}
}
\examples{

#--- Load raster ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

calculate_sampsize(
  mraster = mr,
  rse = 0.01
)

calculate_sampsize(
  mraster = mr
)

calculate_sampsize(
  mraster = mr,
  rse = 0.025,
  start = 0.01,
  end = 0.08,
  increment = 0.01
)

#--- higher variance leads to need for more samples ---#
}
\references{
Benedetti, R., Piersimoni, F., & Postiglione, P. (2015).
Sampling spatial units for agricultural surveys. pp 202-203. Berlin: Springer.
}
\seealso{
Other calculate functions: 
\code{\link{calculate_allocation_existing}()},
\code{\link{calculate_allocation}()},
\code{\link{calculate_coobs}()},
\code{\link{calculate_distance}()},
\code{\link{calculate_pcomp}()},
\code{\link{calculate_pop}()},
\code{\link{calculate_representation}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{calculate functions}
