% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_map.R
\name{strat_map}
\alias{strat_map}
\title{Map 2 stratified rasters}
\usage{
strat_map(
  sraster,
  sraster2,
  stack = FALSE,
  filename = NULL,
  overwrite = FALSE,
  plot = FALSE,
  details = FALSE
)
}
\arguments{
\item{sraster}{spatRaster. Primary stratification raster.}

\item{sraster2}{spatRaster. Secondary stratification raster.}

\item{stack}{Logical. Default = \code{FALSE}. If \code{TRUE}, output raster will be
3 layers: \code{strata, strata2, stratamapped}.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}

\item{plot}{Logical. Plots output strata raster and visualized
strata with boundary dividers.}

\item{details}{Logical. If \code{FALSE} (default) output is a mapped stratified spatRaster object.
If \code{TRUE} return a list where \code{$outRaster} is the mapped stratified raster, and
\code{$lookUp} is the lookup table for the stratification.}
}
\value{
A spatRaster object.
}
\description{
Map stratified rasters to a combined stratification.
}
\section{Mapping}{

The mapping algorithm will take the stratification from \code{sraster} and combine it with
overlying strata values in \code{sraster2}. This will result in a \code{stratamapped} attribute
where the values from both inputs are combined.

i.e.

If \code{strata = 1} and \code{strata2 = 1} then \code{stratamapped = 11}.

If \code{strata = 2} and \code{strata2 = 14} then \code{stratamapped = 214}.
}

\examples{
#--- load input metrics raster ---#
raster <- system.file("extdata", "sraster.tif", package = "sgsR")
sraster <- terra::rast(raster)

#--- read polygon coverage ---#
poly <- system.file("extdata", "inventory_polygons.shp", package = "sgsR")
fri <- sf::st_read(poly)

#--- stratify polygon coverage ---#
#--- specify polygon attribute to stratify ---#

attribute <- "NUTRIENTS"

#--- specify features within attribute & how they should be grouped ---#
#--- as a single vector ---#

features <- c("poor", "rich", "medium")

srasterfri <- strat_poly(
  poly = fri,
  attribute = attribute,
  features = features,
  raster = sraster
)

#--- map srasters ---#
strat_map(
  sraster = srasterfri,
  sraster2 = sraster
)

strat_map(
  sraster = srasterfri,
  sraster2 = sraster,
  stack = TRUE,
  details = TRUE
)
}
\seealso{
Other stratify functions: 
\code{\link{strat_breaks}()},
\code{\link{strat_kmeans}()},
\code{\link{strat_poly}()},
\code{\link{strat_quantiles}()}
}
\author{
Tristan R.H. Goodbody, Robert Hijmans
}
\concept{stratify functions}
