% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_allocation.R
\name{calculate_allocation}
\alias{calculate_allocation}
\title{Sample allocation type and count}
\usage{
calculate_allocation(
  sraster,
  nSamp,
  allocation = "prop",
  weights = NULL,
  mraster = NULL,
  existing = NULL,
  force = FALSE
)
}
\arguments{
\item{sraster}{spatRaster. Stratification raster to be used for sampling.}

\item{nSamp}{Numeric. Number of desired samples.}

\item{allocation}{Character. Allocation algorithm to be used. Either \code{prop} (default) for proportional allocation,
\code{optim} for optimal allocation (equal sampling cost), \code{equal} for equal number of samples (defined by \code{nSamp})
for each strata, or \code{"manual"} for user defined strata weights defined using \code{weights}.}

\item{weights}{Numeric. Only applicable when \code{allocation = "manual"}. Vector of weights where \code{sum(weights) == 1}. Vector length
must be equal to the number of unique strata where the first numeric value corresponds to stratum 1, second stratum 2 etc.}

\item{mraster}{spatRaster. ALS metric raster. Required when \code{allocation = optim}.}

\item{existing}{sf 'POINT' or data.frame.  Existing plot network.}

\item{force}{Logical. \code{Default = FALSE} - force \code{nSamp} to be exactly the user defined value
in cases where \code{nSamp} and \code{sraster} strata count are not equally divisible. Additional samples often need to be allocated or removed
based on rounding differences resulting from proportional differences between \code{nSamp} and strata coverages in \code{sraster}.
In these instances samples are either added to strata with the lowest number of samples or are removed from strata with the highest number of samples.
Has no effect when \code{existing} is provided.}
}
\value{
Returns a data.frame of:
\itemize{
\item{strata} - Strata ID.
\item{total} - Number of samples to be allocated. Values correspond to under representation (samples needed; positive value) or over representation 
(too many samples; negative value) based on the \code{nSamp} provided.
\item{need} - Required samples per strata based on allocation method. Rounded.
}
}
\description{
Determine how many samples to allocate within strata.
}
\examples{
#--- Load strata raster and existing samples---#
r <- system.file("extdata", "sraster.tif", package = "sgsR")
sr <- terra::rast(r)

e <- system.file("extdata", "existing.shp", package = "sgsR")
e <- sf::st_read(e)

#--- proportional allocation ---#
calculate_allocation(
  sraster = sr,
  nSamp = 50
)

#--- equal allocation ---#
calculate_allocation(
  sraster = sr,
  allocation = "equal",
  nSamp = 10
)

#--- manual allocation ---#
#--- define user-defined weights ---#

weights <- c(0.2, 0.2, 0.5, 0.1)

calculate_allocation(
  sraster = sr,
  allocation = "manual",
  weights = weights,
  nSamp = 200
)

}
\references{
Gregoire, T.G., & Valentine, H.T. (2007). Sampling Strategies for Natural Resources and the Environment (1st ed.).
 Chapman and Hall/CRC. https://doi.org/10.1201/9780203498880
}
\seealso{
Other calculate functions: 
\code{\link{calculate_coobs}()},
\code{\link{calculate_distance}()},
\code{\link{calculate_pcomp}()},
\code{\link{calculate_pop}()},
\code{\link{calculate_representation}()},
\code{\link{calculate_sampsize}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{calculate functions}
