% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbors.R
\name{st_contiguity}
\alias{st_contiguity}
\title{Identify polygon neighbors}
\usage{
st_contiguity(geometry, queen = TRUE, ...)
}
\arguments{
\item{geometry}{an sf or sfc object.}

\item{queen}{default \code{TRUE}. For more see \code{?spdep::poly2nb}}

\item{...}{additional arguments passed to \code{\link[spdep:poly2nb]{spdep::poly2nb()}}}
}
\value{
a list of class \code{nb}
}
\description{
Given an sf geometry of type \code{POLYGON} or \code{MULTIPOLYGON} identify contiguity based neighbors.
}
\details{
Utilizes \code{\link[spdep:poly2nb]{spdep::poly2nb()}}
}
\examples{
# on basic polygons
geo <- sf::st_geometry(guerry)
st_contiguity(geo)
if (requireNamespace("dplyr", quietyl = TRUE)) {
# in a pipe
library(magrittr)
guerry \%>\%
  dplyr::mutate(nb = st_contiguity(geometry), .before = 1)
 }
}
\seealso{
Other neighbors: 
\code{\link{st_dist_band}()},
\code{\link{st_knn}()}
}
\concept{neighbors}
