% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime-constructor.R
\name{spacetime}
\alias{spacetime}
\alias{new_spacetime}
\alias{validate_spacetime}
\alias{is_spacetime}
\alias{is.spacetime}
\title{Construct a \code{spacetime} object}
\usage{
spacetime(.data, .geometry, .loc_col, .time_col, active = "data")

new_spacetime(.data, .geometry, .loc_col, .time_col, active = "data")

validate_spacetime(.data, .geometry, .loc_col, .time_col)

is_spacetime(x, ...)

is.spacetime(x, ...)
}
\arguments{
\item{.data}{an object with base class \code{data.frame} containing location and time
identifiers \code{.loc_col} and \code{.time_col} respectively.}

\item{.geometry}{an \code{sf} object with columns \code{.loc_col} and \code{.time_col}}

\item{.loc_col}{the quoted name of the column containing unique location identifiers. Must be present in both \code{.data} and \code{.geometry}.}

\item{.time_col}{the quoted name of the column containing time periods must be present \code{.data}. See details for more}

\item{active}{default \code{"data"}. The object to make active. See \code{\link[=activate]{activate()}} for more.}

\item{x}{an object to test}

\item{...}{unused}
}
\value{
\itemize{
\item \code{spacetime()} and \code{new_spacetime()} construct spacetime clss objects
\item \code{validate_spacetime()} returns nothing but will elicit a warning or error if the spacetime object is not validly constructed
\item \code{is_spacetime()} and \code{is.spacetime()} return a logical scalar indicating if an object inherits the spacetime class
}
}
\description{
A spacetime object is a collection of a linked data frame and an sf objects.
It can be thought of as geography linked to a table that represents those
geographies over one or more time periods.
}
\details{
Create a spacetime representation of vector data from a \code{data.frame} and an
\code{sf} object with \code{spacetime()}

\code{.time_col} must be able to be sorted. As such, \code{.time_col}
cannot be a character vector. It must have a base type of (\code{typeof()}) either
\code{double} or \code{integer}—the case in dates or factors respectively. An edge case
exists with \code{POSIXlt} class objects as these can be sorted appropriately but
have a base type of \code{list}.

\code{\link[=spacetime]{spacetime()}} is a wrapper around \code{\link[=new_spacetime]{new_spacetime()}}. Spacetimes are
validated before creation with \code{\link[=validate_spacetime]{validate_spacetime()}}.

Check if an object is a spacetime object with \code{\link[=is_spacetime]{is_spacetime()}} or
\code{\link[=is.spacetime]{is.spacetime()}}.
}
\section{Validation}{


\code{validate_spacetime()} checks both \code{.data} and \code{.geometry} to ensure that
the constructed spacetime object meets minimum requirements.:
\itemize{
\item \code{.data} inherits the \code{data.frame} class
\item \code{.geometry} is an \code{sf} object
\item ensures that \code{.time_col} is of the proper class
\item ensures there are no missing geometries in \code{.geometry}
\item checks for duplicate geometries
\item ensures \code{.loc_col} are the same type in \code{.data} and \code{.geometry}
\item lastly informs of missing values in additional columns in \code{.data}
}
}

\examples{

df_fp <- system.file("extdata", "bos-ecometric.csv", package = "sfdep")
geo_fp <- system.file("extdata", "bos-ecometric.geojson", package = "sfdep")

# read in data
df <- read.csv(
  df_fp, colClasses = c("character", "character", "integer", "double", "Date")
)

geo <- sf::st_read(geo_fp)

bos <- spacetime(df, geo, ".region_id", "year")
is_spacetime(bos)
bos


}
