% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-moran-bv-impl.R
\name{global_moran_bv}
\alias{global_moran_bv}
\title{Compute the Global Bivariate Moran's I}
\usage{
global_moran_bv(x, y, nb, wt, nsim = 99)
}
\arguments{
\item{x}{a numeric vector of same length as \code{nb}.}

\item{y}{a numeric vector of same length as \code{nb}.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{nsim}{the number of simulations to run.}
}
\value{
a named list with two elements \code{Ib} and \code{p_sim} containing the bivariate Moran'sI and simulated p-value respectively.
}
\description{
Given two continuous numeric variables, calculate the bivariate Moran's I.
}
\details{
\eqn{
I_B = \frac{\Sigma_i(\Sigma_j{w_{ij}y_j\times x_i})}{\Sigma_i{x_i^2}}
}
}
\examples{
x <- guerry_nb$crime_pers
y <- guerry_nb$wealth
nb <- guerry_nb$nb
wt <- guerry_nb$wt
global_moran_bv(x, y, nb, wt)
}
\seealso{
Other global_moran: 
\code{\link{global_moran_perm}()},
\code{\link{global_moran_test}()},
\code{\link{global_moran}()},
\code{\link{local_moran_bv}()}
}
\concept{global_moran}
