% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_distance.R
\name{st_sd_distance}
\alias{st_sd_distance}
\alias{st_sd_distance.sfg}
\alias{st_sd_distance.sf}
\alias{st_sd_distance.sfc}
\title{Standard deviation distance calculator}
\usage{
st_sd_distance(.x, centre = NULL, weights = NULL, ...)

\method{st_sd_distance}{sfg}(.x, centre = NULL, weights = NULL, ...)

\method{st_sd_distance}{sf}(.x, centre = NULL, weights = NULL, ...)

\method{st_sd_distance}{sfc}(.x, centre = NULL, weights = NULL, ...)
}
\arguments{
\item{.x}{\link{sf} points 2D or 3D}

\item{centre}{One central point of class \emph{sf}, \emph{sfc}, \emph{numeric}
(length 2), \emph{matrix} (2 col, 1 row), \emph{data.frame}  (2 col, 1 row),
or \emph{list} (length 2). Default \code{NULL}, means a calculation of the \code{\link[=st_central_point]{st_central_point()}}
from \code{.x} localities.}

\item{weights}{Numeric. Same length as number of points in \code{.x}.}

\item{...}{other parameters for \code{\link[sf:geos_measures]{sf::st_distance()}}}
}
\value{
A sf \code{"POLYGON"} with atributes:
\itemize{
\item \code{radius} (standard deviation distance)
\item \code{area} surrounding,
\item \code{perimeter},
\item \code{center} coordinates,
\item \code{weigted} indicator if weights were used or not in the calculaton.
}
}
\description{
Calculate the spatial deviaction distance from a points sf dataset.
}
\examples{
  requireNamespace("ggplot2", quietly = TRUE)
  library(sf, quietly = TRUE)
  library(ggplot2)
  bbx <- matrix(c(697047,9553483,
                  696158,9560476,
                  700964,9561425,
                  701745,9555358),
                byrow = TRUE,
                ncol = 2)
  bbx <- st_multipoint(bbx)
  bbx <- st_cast(bbx,"POLYGON")
  bbx <- st_sfc(bbx, crs = 31992)
  set.seed(1234)
  points <- st_sf(geometry = st_sample(bbx, 100))
  SDD <- st_sd_distance(points)
  ggplot() +
    geom_sf(data = SDD, fill = NA, color = "darkolivegreen") +
    geom_sf(data = points, color = "steelblue", size = 0.5)
}
\author{
Gabriel Gaona
}
