% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{to_global}
\alias{to_global}
\title{Merge sentiment measures into one global sentiment measure}
\usage{
to_global(sentomeasures, lexicons = 1, features = 1, time = 1)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{lexicons}{a \code{numeric} vector of weights, of size \code{length(sentomeasures$lexicons)}, in the same order
and summing to one. By default set to 1, which means equally weighted.}

\item{features}{a \code{numeric} vector of weights, of size \code{length(sentomeasures$features)}, in the same order
and summing to one. By default set to 1, which means equally weighted.}

\item{time}{a \code{numeric} vector of weights, of size \code{length(sentomeasures$time)}, in the same order and summing
to one. By default set to 1, which means equally weighted.}
}
\value{
A \code{data.frame} with the values for the global sentiment measure under the \code{global} column and dates as
row names.
}
\description{
Merges all sentiment measures into one global textual sentiment measure based on a set of weights to
indicate the importance of each component in the \code{lexicons}, \code{features}, and \code{time} vectors as specified
in the input \code{sentomeasures} object. Every measure receives a weight in the global measure equal to the multiplication
of the supplied weights of the components it is contained of. The global sentiment measure then corresponds to a
weighted average of these weights times the sentiment scores, per date.
}
\details{
This function returns no \code{sentomeasures} object, however the global sentiment measure as outputted can
be added to regressions as an additional variable using the \code{x} argument in the \code{\link{sento_model}} function.
}
\examples{
data("usnews")
data("lexicons")
data("valence")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 1250)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# merge into one global sentiment measure, with specified weighting for lexicons and features
global <- to_global(sentomeasures, lexicons = c(0.40, 0.60),
                                   features = c(0.10, 0.20, 0.30, 0.40),
                                   time = 1)

}
\seealso{
\code{\link{sento_model}}
}
\author{
Samuel Borms
}
