% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_cbsem.R
\name{estimate_cbsem}
\alias{estimate_cbsem}
\title{seminr estimate_cbsem() function}
\usage{
estimate_cbsem(data, measurement_model, structural_model, item_associations=NULL,
               estimator="MLR", ...)
}
\arguments{
\item{data}{A \code{dataframe} containing the indicator measurement data.}

\item{measurement_model}{A list represention of how constructs are measured
by their items, generated using \code{\link{constructs}}.
Note that only reflective constructs are supported for CBSEM models,
though a composite measurement model can be converted into a reflective one
using \code{\link{as.reflective}}.}

\item{structural_model}{A source-to-target matrix representing the
structural model, generated by \code{\link{relationships}}.}

\item{item_associations}{An item-to-item matrix representing error
covariances that are freed for estimation.
This matrix is created by \code{associations()}, or defaults to NULL
(no associations).}

\item{estimator}{A character string indicating which estimation method to use
in Lavaan. It defaults to "MLR" for robust estimation.
See the Lavaan documentation for other supported estimators.}

\item{...}{Any other parameters to pass to \code{lavaan::sem} during
estimation.}
}
\description{
The \code{seminr} package provides a natural syntax for researchers to describe
structural equation models.
}
\examples{
mobi <- mobi

#seminr syntax for creating measurement model
mobi_mm <- constructs(
  reflective("Image",        multi_items("IMAG", 1:5)),
  reflective("Quality",      multi_items("PERQ", 1:7)),
  reflective("Value",        multi_items("PERV", 1:2)),
  reflective("Satisfaction", multi_items("CUSA", 1:3)),
  reflective("Complaints",   single_item("CUSCO")),
  reflective("Loyalty",      multi_items("CUSL", 1:3))
)

#seminr syntax for freeing up item-item covariances
mobi_am <- associations(
  item_errors(c("PERQ1", "PERQ2"), "IMAG1")
)

#seminr syntax for creating structural model
mobi_sm <- relationships(
  paths(from = c("Image", "Quality"), to = c("Value", "Satisfaction")),
  paths(from = c("Value", "Satisfaction"), to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

# Estimate model and get results
mobi_cbsem <- estimate_cbsem(mobi, mobi_mm, mobi_sm, mobi_am)

# Use or capture the summary object for more results and metrics
summary(mobi_cbsem)

cbsem_summary <- summary(mobi_cbsem)
cbsem_summary$descriptives$correlations$constructs

}
\references{
Joreskog, K. G. (1973). A general method for estimating a linear structural equation system In: Goldberger AS, Duncan OD, editors. Structural Equation Models in the Social Sciences. New York: Seminar Press.
}
\seealso{
\code{\link{as.reflective}}
         \code{\link{relationships}} \code{\link{constructs}}
         \code{\link{paths}}
         \code{\link{associations}} \code{\link{item_errors}}
}
