% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelClass.R
\name{setSd}
\alias{setSd}
\alias{setSd,odeModel-method}
\title{Set the standard deviation of the measurements}
\usage{
setSd(odeModel, sd)

\S4method{setSd}{odeModel}(odeModel, sd)
}
\arguments{
\item{odeModel}{an object of the class odeModel}

\item{sd}{a matrix with the standard deviations of the measurements}
}
\value{
an object of odeModel
}
\description{
With multiple measurements a standard deviation can be calculated for every point of
measurement. The standard deviation is used to weigh the estimated data points in the 
cost function.
}
\examples{

data(uvbData)
data(uvbModel)

sd_uvb <- uvbData[,7:11]

newModel <- setSd(odeModel = uvbModel, sd = sd_uvb)

}
