% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dVm}
\alias{dVm}
\title{Density of the von Mises}
\usage{
dVm(x, mu, kappa)
}
\arguments{
\item{x}{evaluation angles, not necessary in \eqn{[\pi,\pi)}.}

\item{mu}{circular mean.}

\item{kappa}{non-negative concentration parameter.}
}
\value{
A vector of the same length as \code{x} containing the density.
}
\description{
Computes the density of a von Mises in a numerically stable way.
}
\examples{
x <- seq(-pi, pi, l = 200)
plot(x, x, type = "n", ylab = "Density", ylim = c(0, 1))
for (i in 0:20) {
  lines(x, dVm(x = x, mu = 0, kappa = 5 * i / 20),
        col = rainbow(21)[i + 1])
}
}
\references{
Jammalamadaka, S. R. and SenGupta, A. (2001) \emph{Topics in Circular Statistics}. World Scientific, Singapore. \url{https://doi.org/10.1142/4031}
}
