% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printFunctions.R
\docType{methods}
\name{print.sdcMicroObj}
\alias{print.sdcMicroObj}
\alias{print,sdcMicroObj-method}
\title{Print and Extractor Functions for objects of class \code{\link{sdcMicroObj-class}}}
\usage{
\S4method{print}{sdcMicroObj}(x, type = "kAnon", docat = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{\link{sdcMicroObj-class}}}

\item{type}{Selection of the content to be returned or printed}

\item{docat}{logical, if TRUE (default) the results will be actually printed}

\item{...}{the type argument for the print method, currently supported are:
\itemize{
\item general: basic information on the input obj such as the number of observations
and variables.
\item kAnon: displays information about 2- and 3-anonymity
\item ls: displays various information if local suppression has been applied.
\item pram: displays various information if post-randomization has been applied.
\item recode: shows information about categorical key variables before and after recoding
\item risk: displays information on re-identification risks
\item numrisk: displays risk- and utility measures for numerical key variables
}}
}
\description{
Descriptive print function for Frequencies, local Supression, Recoding,
categorical risk and numerical risk.
}
\details{
Possible values for the type argument of the print function are: "freq": for
Frequencies, "ls": for Local Supression output, "pram": for results of
post-randomization "recode":for Recodes, "risk": forCategorical risk and
"numrisk": for Numerical risk.

Possible values for the type argument of the freq function are: "fk": Sample
frequencies and "Fk": weighted frequencies.
}
\examples{
data(testdata)
\donttest{
sdc <- createSdcObj(testdata,
  keyVars=c('urbrur','roof','walls','relat','sex'),
  pramVars=c('water','electcon'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- microaggregation(sdc, method="mdav", aggr=3)
print(sdc)
print(sdc, type="general")
print(sdc, type="ls")
print(sdc, type="recode")
print(sdc, type="risk")
print(sdc, type="numrisk")
print(sdc, type="pram")
print(sdc, type="kAnon")
print(sdc, type="comp_numvars")
}
}
\author{
Alexander Kowarik, Matthias Templ, Bernhard Meindl
}
\keyword{classes}
