% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.sdcMicroObj}
\alias{plot.sdcMicroObj}
\title{Plotfunctions for objects of class \linkS4class{sdcMicroObj}}
\usage{
\method{plot}{sdcMicroObj}(x, type = "ls", ...)
}
\arguments{
\item{x}{An object of class \linkS4class{sdcMicroObj}}

\item{type}{specified what kind of plot will be generated
\itemize{
\item \code{"ls"}: plot of local suppressions in key variables
}}

\item{...}{currently ignored}
}
\value{
a \code{ggplot} plot object or (invisible) \code{NULL} if local suppression
using \code{\link[=kAnon]{kAnon()}} has not been applied
}
\description{
Descriptive plot function for \linkS4class{sdcMicroObj}-objects. Currently
only visualization of local supression is implemented.
}
\examples{
\donttest{
data(testdata)
sdc <- createSdcObj(testdata,
  keyVars = c("urbrur", "roof", "walls", "relat", "sex"),
  w = "sampling_weight")
sdc <- kAnon(sdc, k = 3)
plot(sdc, type = "ls")
}
}
\author{
Bernhard Meindl
}
\keyword{classes}
