% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_baseline.R
\name{check_baseline}
\alias{check_baseline}
\title{Check for baseline boundary}
\usage{
check_baseline(
  formula = NULL,
  data = NULL,
  fit_sclr = NULL,
  fit_lr = NULL,
  conf_lvl = 0.95,
  verbose = TRUE
)
}
\arguments{
\item{formula}{Formula to use for model fitting.}

\item{data}{Optional dataframe.}

\item{fit_sclr}{Fit object returned by \code{\link{sclr}}.}

\item{fit_lr}{Fit object returned by \code{\link[stats]{glm}}.}

\item{conf_lvl}{Confidence level for the test}

\item{verbose}{Whether to print message based on test result.}
}
\value{
A \code{\link[tibble]{tibble}} with a summary.
}
\description{
Fits the scaled logit model as well as logistic regression. Does
a likelihood ratio test.
}
\examples{
library(sclr)
l1 <- sclr_ideal_data(n = 50, theta = 1e6, seed = 20191104)
check_baseline(status ~ logHI, l1)
}
