% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.rawDist.R
\name{create.rawDist}
\alias{create.rawDist}
\title{Create rawDist data from arbitary coordinates}
\usage{
create.rawDist(spots, gbs, main, spot.seq.names = NULL, sample.name = NULL,
  scaling.factor = 1, unit = NULL)
}
\arguments{
\item{spots}{A list of \code{\link[spatstat]{ppp}} objects or a single \code{ppp} object defining the sample spot sequences. If \code{\link[spatstat]{marks}} are not specified, sequencial names will be used.}

\item{gbs}{\code{\link[spatstat]{psp}} object defining the growth lines. If \code{\link[spatstat]{marks}} are not specified, sequencial names will be used.}

\item{main}{\code{\link[spatstat]{psp}} object defining the measurement axis. If \code{\link[spatstat]{marks}} are not specified, sequencial 'main' will assigned as the marks. Only on `main` axis is allowed per `rawDist` object.}

\item{spot.seq.names}{optional. A character vector of equal length to number of sample \code{spots} sequences defining the name for each sequence. If left empty sequencial names will be generated.}

\item{sample.name}{optional. A character vector (\code{length == 1}) defining the name of the sample.}

\item{scaling.factor}{optional. A numeric value defining the scale of photograph in pixels / \code{unit}. Defaults to 1.}

\item{unit}{optional. A charater vector (\code{length == 1}) defining the unit of measurements. See \code{scale}.}
}
\value{
Returns a list of class \code{rawDist}, which contains \link[spatstat]{spatstat} point patterns. The returned \code{rawDist} can be plotted using the generic plotting command.
}
\description{
Creates a \code{rawDist} data object from arbitary coordinates ready for \link[=plot.rawDist]{plotting} or \link[=spot.dist]{sample spot alignment}.
}
\details{
This function can be used to create arbitary test data, which can be passed further on in \code{sclero} package function hierarchy.
}
\examples{
dev.off()
W <- square(10)
S <- ppp(x = c(7, 5, 3), y = rep(5,3), window = W)
G <- psp(x0 = c(8,6,4,2), y0 = rep(2,4), x1 = c(8,6,4,2), y1 = rep(8,4), window = W)
M <- psp(x0 = 0, x1 = 8, y0 = 5, y1 = 5, window = W)
x <- create.rawDist(spots = S, gbs = G, main = M)
plot(x)

## Generate random points for alignment
set.seed(1)
S <- rpoint(n = 5, win = owin(xrange = c(2,7), yrange = c(5,7)))
S$window <- W
G <- psp(x0 = c(7,5,3,1), y0 = rep(2,4), x1 = c(9,7,5,3), y1 = rep(8,4), window = W)
M <- psp(x0 = 0, x1 = 8, y0 = 1, y1 = 1, window = W)
x <- create.rawDist(spots = S, gbs = G, main = M)
plot(x)
y <- spot.dist(x)
plot(y)
}
\author{
Mikko Vihtakari
}
\seealso{
\code{\link{read.ijdata}} for generating \code{IJDATA} objects.

\code{\link{convert.ijdata}} for converting \code{IJDATA} objects to \code{rawDist} objects.

\code{\link{plot.rawDist}} for plotting.

\code{\link{spot.dist}} for aligning sample spots.
}

